﻿//
//  UdpDataReceivedEventArgs.cs
//
//  Author:
//       tsntsumi <tsntsumi at tsutsumi.com>
//
//  Copyright (c) 2015 tsntsumi
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

/// @file
/// <summary>
/// Udp データ受信イベント引数クラスを実装します。
/// </summary>
/// @since 2015.8.15
using System;
using System.Net;

namespace SocketNet
{
	/// <summary>
	/// データ受信イベントのデータ。
	/// </summary>
	public class UdpDataReceivedEventArgs : EventArgs
	{
		/// <summary>
		/// 関連付けられたソースエンドポイントを取得します。
		/// </summary>
		public IPEndPoint SourceEndPoint { get; private set; }

		/// <summary>
		/// 関連付けられたデータを取得します。
		/// </summary>
		public byte[] Data { get; private set; }		

		/// <summary>
		/// コンストラクタ。
		/// </summary>
		/// <param name="sourceEndPoint">関連付けられたソースエンドポイント。</param>
		/// <param name="data">関連付けられたデータ。</param>
		public UdpDataReceivedEventArgs(IPEndPoint sourceEndPoint, byte[] data)
		{
			SourceEndPoint = sourceEndPoint;
			Data = data;
		}
	}
}

