/* Copyright (c) 2009, Code Aurora Forum. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * Neither the name of Code Aurora Forum, Inc. nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __ASM_ARCH_MSM_BUS_BOARD_H
#define __ASM_ARCH_MSM_BUS_BOARD_H

#include <linux/types.h>
#include <linux/input.h>

#if defined(CONFIG_ARCH_MSM8X60)

#define FABRIC_ID_KEY 1024
#define SLAVE_ID_KEY ((FABRIC_ID_KEY) >> 1)
#define GET_FAB_INDEX(a, b) ((a)%(b))

/* Topology related enums */
enum {
	MSM_BUS_FAB_APPSS = 0,
	MSM_BUS_FAB_SYSTEM = 1024,
	MSM_BUS_FAB_MMSS = 2048,
};

enum {
	MSM_BUS_APPSS_MASTER_SMPSS_M0 = MSM_BUS_FAB_APPSS + 1,
	MSM_BUS_APPSS_MASTER_SMPSS_M1,
	MSM_BUS_APPSS_MASTER_FAB_MMSS,
	MSM_BUS_APPSS_MASTER_FAB_SYSTEM,
	MSM_BUS_APPSS_MASTER_LAST = MSM_BUS_APPSS_MASTER_FAB_SYSTEM,

	MSM_BUS_SYSTEM_MASTER_FAB_APPSS = MSM_BUS_FAB_SYSTEM + 1,
	MSM_BUS_SYSTEM_MASTER_SPS,
	MSM_BUS_SYSTEM_MASTER_ADM0_PORT0,
	MSM_BUS_SYSTEM_MASTER_ADM0_PORT1,
	MSM_BUS_SYSTEM_MASTER_ADM1_PORT0,
	MSM_BUS_SYSTEM_MASTER_ADM1_PORT1,
	MSM_BUS_SYSTEM_MASTER_LPASS_PROC,
	MSM_BUS_SYSTEM_MASTER_MSS_PROCI,
	MSM_BUS_SYSTEM_MASTER_MSS_PROCD,
	MSM_BUS_SYSTEM_MASTER_MSS_MDM_PORT0,
	MSM_BUS_SYSTEM_MASTER_LPASS,
	MSM_BUS_SYSTEM_MASTER_CPSS_FPB,
	MSM_BUS_SYSTEM_MASTER_SYSTEM_FPB,
	MSM_BUS_SYSTEM_MASTER_MMSS_FPB,
	MSM_BUS_SYSTEM_MASTER_ADM1_AHB_CI,
	MSM_BUS_SYSTEM_MASTER_ADM0_AHB_CI,
	MSM_BUS_SYSTEM_MASTER_MSS_MDM_PORT1,
	MSM_BUS_SYSTEM_MASTER_LAST = MSM_BUS_SYSTEM_MASTER_MSS_MDM_PORT1,

	MSM_BUS_MMSS_MASTER_MDM_PORT0 = MSM_BUS_FAB_MMSS + 1,
	MSM_BUS_MMSS_MASTER_MDM_PORT1,
	MSM_BUS_MMSS_MASTER_ADM1_PORT0,
	MSM_BUS_MMSS_MASTER_ROTATOR,
	MSM_BUS_MMSS_MASTER_GRAPHICS_3D,
	MSM_BUS_MMSS_MASTER_JPEG_DEC,
	MSM_BUS_MMSS_MASTER_GRAPHICS_2D_CORE0,
	MSM_BUS_MMSS_MASTER_VFE,
	MSM_BUS_MMSS_MASTER_VPE,
	MSM_BUS_MMSS_MASTER_JPEG_ENC,
	MSM_BUS_MMSS_MASTER_HD_CODEC_PORT0,
	MSM_BUS_MMSS_MASTER_APPS_FAB,
	MSM_BUS_MMSS_MASTER_HD_CODEC_PORT1,
};

enum {
	MSM_BUS_APPSS_SLAVE_EBI_CH0 = MSM_BUS_FAB_APPSS + SLAVE_ID_KEY,
	MSM_BUS_APPSS_SLAVE_SMPSS_L2,
	MSM_BUS_APPSS_SLAVE_FAB_MMSS,
	MSM_BUS_APPSS_SLAVE_FAB_SYSTEM,
	MSM_BUS_APPSS_SLAVE_LAST = MSM_BUS_APPSS_SLAVE_FAB_SYSTEM,

	MSM_BUS_SYSTEM_SLAVE_FAB_APPS = MSM_BUS_FAB_SYSTEM + SLAVE_ID_KEY,
	MSM_BUS_SYSTEM_SLAVE_SPS,
	MSM_BUS_SYSTEM_SLAVE_SYSEM_IMEM,
	MSM_BUS_SYSTEM_SLAVE_SMPSS,
	MSM_BUS_SYSTEM_SLAVE_MSS,
	MSM_BUS_SYSTEM_SLAVE_LPASS,
	MSM_BUS_SYSTEM_SLAVE_CPSS_FPB,
	MSM_BUS_SYSTEM_SLAVE_SYSTEM_FPB,
	MSM_BUS_SYSTEM_SLAVE_MMSS_FPB,

	MSM_BUS_MMSS_SLAVE_SMI = MSM_BUS_FAB_MMSS + SLAVE_ID_KEY,
	MSM_BUS_MMSS_SLAVE_FAB_APPS,
	MSM_BUS_MMSS_SLAVE_MM_IMEM,
	MSM_BUS_MMSS_SLAVE_LAST = MSM_BUS_MMSS_SLAVE_MM_IMEM,
};
enum {
	MSM_BUS_SYSTEM_TIERED_SLAVE_FIRST = 0,
	MSM_BUS_SYSTEM_TIERED_SLAVE_FAB_APPSS = 0,
	MSM_BUS_SYSTEM_TIERED_SLAVE_SYSTEM_IMEM,
	MSM_BUS_SYSTEM_TIERED_SLAVE_SLAVE_COUNT,

	MSM_BUS_MMSS_TIERED_SLAVE_FIRST = 0,
	MSM_BUS_MMSS_TIERED_SLAVE_SMI = 0,
	MSM_BUS_MMSS_TIERED_SLAVE_FAB_APPS,
	MSM_BUS_MMSS_TIERED_SLAVE_COUNT,

	MSM_BUS_APPSS_TIERED_SLAVE_FIRST = 0,
	MSM_BUS_APPSS_TIERED_SLAVE_EBI_CH0 = 0,
	MSM_BUS_APPSS_TIERED_SLAVE_SMPSS_L2,
	MSM_BUS_APPSS_TIERED_SLAVE_COUNT,
};

#endif

#endif /*__ASM_ARCH_MSM_BUS_BOARD_H */
