/* drivers/video/msm/mddi_nt_panels/mddi_nt_tmd_mdp42.c
 *
 * Copyright (C) 2010 Sony Ericsson Mobile Communications AB.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 */

#include "mddihost.h"
#include "msm_fb_panel.h"
#include "mddi_nt_panel.h"

static const struct novatek_reg_set novatek_init_regs[] = {
	{ 0xC980, 0x0001 },
	{ 0x7DC0, 0x0001 },
	{ 0x0180, 0x0014 },
	{ 0x0280, 0x0000 },
	{ 0x0380, 0x0033 },
	{ 0x0480, 0x0048 },
	{ 0x0780, 0x0000 },
	{ 0x0880, 0x0044 },
	{ 0x0980, 0x0054 },
	{ 0x0A80, 0x0012 },
	{ 0x1280, 0x0000 },
	{ 0x1380, 0x0010 },
	{ 0x1480, 0x000D },
	{ 0x1580, 0x00A0 },
	{ 0x1A80, 0x0062 },
	{ 0x1F80, 0x0000 },
	{ 0x2080, 0x0001 },
	{ 0x2180, 0x0066 },
	{ 0x9480, 0x00BF },
	{ 0x9580, 0x0000 },
	{ 0x9680, 0x0000 },
	{ 0x9780, 0x00B4 },
	{ 0x9880, 0x000D },
	{ 0x9980, 0x002C },
	{ 0x9A80, 0x000A },
	{ 0x9B80, 0x0001 },
	{ 0x9C80, 0x0001 },
	{ 0x9D80, 0x0000 },
	{ 0x9E80, 0x0000 },
	{ 0x9F80, 0x0000 },
	{ 0xA080, 0x000A },
	{ 0xA280, 0x0005 },
	{ 0xA380, 0x002E },
	{ 0xA480, 0x000E },
	{ 0xA580, 0x00C0 },
	{ 0xA680, 0x0001 },
	{ 0xA780, 0x0000 },
	{ 0xA980, 0x0000 },
	{ 0xAA80, 0x0000 },
	{ 0xE780, 0x0000 },
	{ 0xED80, 0x0000 },
	{ 0xFB80, 0x0000 },
	{ 0xF380, 0x00CC },
	{ 0xFBC0, 0x0001 },
	{ 0x8CC9, 0x00C0 },	/* Disable internal resistor */
	{ 0x8CC1, 0x0040 },
	{ 0x89CE, 0x0003 },
	{ 0x8FCE, 0x0013 },
	{ 0x8FCF, 0x0011 },
	{ 0x90C0, 0x0013 },
	{ 0x90C1, 0x0003 },
	{ 0x68C0, 0x0008 },
	{ 0xEE80, 0x0000 },
	{ 0x89C3, 0x009B },
	{ 0x92C2, 0x0008 },
	/* ADD Gamma Code (Red) */
	{ 0x2480, 0x0020 },
	{ 0x2580, 0x0027 },
	{ 0x2680, 0x0042 },
	{ 0x2780, 0x006D },
	{ 0x2880, 0x0020 },
	{ 0x2980, 0x0037 },
	{ 0x2A80, 0x0062 },
	{ 0x2B80, 0x0092 },
	{ 0x2D80, 0x001E },
	{ 0x2F80, 0x0025 },
	{ 0x3080, 0x00CE },
	{ 0x3180, 0x001E },
	{ 0x3280, 0x0041 },
	{ 0x3380, 0x005B },
	{ 0x3480, 0x00BF },
	{ 0x3580, 0x00DB },
	{ 0x3680, 0x00F7 },
	{ 0x3780, 0x0073 },
	{ 0x3880, 0x0020 },
	{ 0x3980, 0x0022 },
	{ 0x3A80, 0x0038 },
	{ 0x3B80, 0x0053 },
	{ 0x3D80, 0x002E },
	{ 0x3F80, 0x0045 },
	{ 0x4080, 0x0066 },
	{ 0x4180, 0x0038 },
	{ 0x4280, 0x0017 },
	{ 0x4380, 0x001F },
	{ 0x4480, 0x006F },
	{ 0x4580, 0x001C },
	{ 0x4680, 0x0049 },
	{ 0x4780, 0x005F },
	{ 0x4880, 0x008E },
	{ 0x4980, 0x00A9 },
	{ 0x4A80, 0x00CE },
	{ 0x4B80, 0x0074 },
	/* ADD Gamma Code (Green) */
	{ 0x4C80, 0x0020 },
	{ 0x4D80, 0x003A },
	{ 0x4E80, 0x0055 },
	{ 0x4F80, 0x0079 },
	{ 0x5080, 0x002A },
	{ 0x5180, 0x0041 },
	{ 0x5280, 0x0063 },
	{ 0x5380, 0x00A1 },
	{ 0x5480, 0x0019 },
	{ 0x5580, 0x0024 },
	{ 0x5680, 0x00D5 },
	{ 0x5780, 0x001C },
	{ 0x5880, 0x003D },
	{ 0x5980, 0x0059 },
	{ 0x5A80, 0x00BE },
	{ 0x5B80, 0x00DB },
	{ 0x5C80, 0x00F7 },
	{ 0x5D80, 0x0073 },
	{ 0x5E80, 0x0020 },
	{ 0x5F80, 0x0022 },
	{ 0x6080, 0x0038 },
	{ 0x6180, 0x0055 },
	{ 0x6280, 0x0028 },
	{ 0x6380, 0x0041 },
	{ 0x6480, 0x0061 },
	{ 0x6580, 0x0040 },
	{ 0x6680, 0x0019 },
	{ 0x6780, 0x0022 },
	{ 0x6880, 0x0075 },
	{ 0x6980, 0x001B },
	{ 0x6A80, 0x003E },
	{ 0x6B80, 0x0055 },
	{ 0x6C80, 0x009D },
	{ 0x6D80, 0x00CA },
	{ 0x6E80, 0x00E4 },
	{ 0x6F80, 0x007F },
	/* ADD Gamma Code (Blue) */
	{ 0x7080, 0x0020 },
	{ 0x7180, 0x003A },
	{ 0x7280, 0x0060 },
	{ 0x7380, 0x0089 },
	{ 0x7480, 0x002B },
	{ 0x7580, 0x0045 },
	{ 0x7680, 0x0066 },
	{ 0x7780, 0x00B7 },
	{ 0x7880, 0x001B },
	{ 0x7980, 0x0026 },
	{ 0x7A80, 0x00DF },
	{ 0x7B80, 0x001C },
	{ 0x7C80, 0x0047 },
	{ 0x7D80, 0x005C },
	{ 0x7E80, 0x00BF },
	{ 0x7F80, 0x00DB },
	{ 0x8080, 0x00F7 },
	{ 0x8180, 0x0073 },
	{ 0x8280, 0x0020 },
	{ 0x8380, 0x0021 },
	{ 0x8480, 0x0038 },
	{ 0x8580, 0x0054 },
	{ 0x8680, 0x0026 },
	{ 0x8780, 0x003B },
	{ 0x8880, 0x0063 },
	{ 0x8980, 0x0035 },
	{ 0x8A80, 0x001B },
	{ 0x8B80, 0x0026 },
	{ 0x8C80, 0x005D },
	{ 0x8D80, 0x001A },
	{ 0x8E80, 0x0036 },
	{ 0x8F80, 0x0054 },
	{ 0x9080, 0x008A },
	{ 0x9180, 0x00B4 },
	{ 0x9280, 0x00E4 },
	{ 0x9380, 0x007F },
	{0, 0}
};

static const struct novatek_reg_set novatek_setup_regs[] = {
	{ 0x3500, 0x0000 },	/* Set TE ON */
	{ 0x4400, 0x0000 },
	{ 0x4401, 0x0000 },	/* Set Tear line */
	{ 0x3600, 0x00d4 },	/* SET_ADDRESS_MODE */
	{ 0x3A00, 0x0077 },	/* SET_PIXEL_FORMAT */
	{ 0x0000,     10 },	/* Wait 10ms (min.) */
	{ 0x1100, 0x0000 },	/* EXIT_SLEEP_MODE */
	{ 0x0000,    120 },	/* Wait 120ms (min.) */
	{ 0x2A00, 0x0000 },	/* SET_HORIZONTAL_ADDRESS_0 */
	{ 0x2A01, 0x0000 },	/* SET_HORIZONTAL_ADDRESS_1 */
	{ 0x2A02, 0x0001 },	/* SET_HORIZONTAL_ADDRESS_2 */
	{ 0x2A03, 0x00DF },	/* SET_HORIZONTAL_ADDRESS_3 */
	{ 0x2B00, 0x0000 },	/* SET_VERTICAL_ADDRESS_0 */
	{ 0x2B01, 0x0000 },	/* SET_VERTICAL_ADDRESS_1 */
	{ 0x2B02, 0x0003 },	/* SET_VERTICAL_ADDRESS_2 */
	{ 0x2B03, 0x0055 },	/* SET_VERTICAL_ADDRESS_3 */
	{ 0x2D00, 0x0000 },	/* SET_RAM_ADDRESS_0 */
	{ 0x2D01, 0x0000 },	/* SET_RAM_ADDRESS_1 */
	{ 0x2D02, 0x0003 },	/* SET_RAM_ADDRESS_2 */
	{ 0x2D03, 0x0055 },	/* SET_RAM_ADDRESS_3 */
	{0, 0}
};

static const struct novatek_reg_set novatek_display_on_regs[] = {
	{ 0x2900, 0x0000 },	/* SET_DISPLAY_ON */
	{ 0x5300, 0x0024 },
	{ 0x5100, 0x00FF },	/* LED ON */
	{ 0x5500, 0x0003 },
	{ 0x3BC0, 0x00FF },
	{0, 0}
};

static const struct novatek_reg_set novatek_display_off_regs[] = {
	{ 0x2800, 0x0000 },	/* SET_DISPLAY_OFF */
	{ 0x0000,     18 },	/* spec says sleep >17 ms */
	{ 0, 0 }
};

static const struct novatek_reg_set novatek_takedown_regs[] = {
	{ 0x1000, 0x0000 },
	{ 0x0000,    120 },	/* not in TMD spec, 120 ms sleep needed to */
				/* enter standby */
	{ 0, 0 }
};

static const struct novatek_reg_set novatek_standby_regs[] = {
	{ 0x4F00, 0x0001 },
	{ 0, 0 }
};

static struct msm_fb_panel_data novatek_panel_data;

static struct msm_fb_panel_data *get_panel_info(void)
{
	novatek_panel_data.panel_info.xres = 480;
	novatek_panel_data.panel_info.yres = 854;
	novatek_panel_data.panel_info.bpp = 24;
	novatek_panel_data.panel_info.type = MDDI_PANEL;
	novatek_panel_data.panel_info.wait_cycle = 0;
	novatek_panel_data.panel_info.pdest = DISPLAY_1;
	novatek_panel_data.panel_info.fb_num = 2;
	novatek_panel_data.panel_info.clk_rate = 192000000;
	novatek_panel_data.panel_info.clk_min =  190000000;
	novatek_panel_data.panel_info.clk_max =  200000000;
	novatek_panel_data.panel_info.mddi.vdopkt = MDDI_DEFAULT_PRIM_PIX_ATTR;
	novatek_panel_data.panel_info.lcd.refx100 = 5950;
	novatek_panel_data.panel_info.lcd.v_back_porch = 14;
	novatek_panel_data.panel_info.lcd.v_front_porch = 2;
	novatek_panel_data.panel_info.lcd.v_pulse_width = 0;
	novatek_panel_data.panel_info.lcd.vsync_notifier_period = 0;

	return &novatek_panel_data;
}

static struct novatek_controller novatek_controller_panel = {
	.init		= novatek_init_regs,
	.setup		= novatek_setup_regs,
	.turn_on	= novatek_display_on_regs,
	.turn_off	= novatek_display_off_regs,
	.takedown	= novatek_takedown_regs,
	.standby	= novatek_standby_regs,
	.get_panel_info = get_panel_info,
};

const struct panel_id novatek_panel_id_tmd_mdp42_rev_c = {
	.name = "TMD MDDI Type 2 (cut1)",
	.reg_count = 2,
	.regs = { {0xDA00, 0x0F}, {0xDC00, 0x0A} },
	.pinfo = &novatek_controller_panel,
	.mddi_type = 1,
	.width = 51,
	.height = 89,
	.suspend_support = 1,
	.esd_support = 1,
};

const struct panel_id novatek_panel_id_tmd_mdp42_rev_d = {
	.name = "TMD MDDI Type 2 (cut2)",
	.reg_count = 2,
	.regs = { {0xDA00, 0x0F}, {0xDC00, 0x0B} },
	.pinfo = &novatek_controller_panel,
	.mddi_type = 2,
	.width = 51,
	.height = 89,
	.suspend_support = 1,
	.esd_support = 1,
};

