/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.twitterplugin.service;

import android.app.Instrumentation;
import android.app.Instrumentation.ActivityMonitor;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.PatternMatcher;
import android.test.InstrumentationTestCase;

import com.sonyericsson.eventstream.twitterplugin.PluginConstants;
import com.sonyericsson.eventstream.twitterplugin.PluginConstants.EventStreamIntentActions;
import com.sonyericsson.eventstream.twitterplugin.PluginConstants.EventStreamIntentExtraParams;
import com.sonyericsson.eventstream.twitterplugin.service.EventStreamListener;

/**
 * Test class for the configuration activity
 */
public class UEventStreamListenerTests extends InstrumentationTestCase {

    Context mContext;

    @Override
    protected void setUp() throws Exception {
        mContext = getInstrumentation().getTargetContext();

        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testLaunchWebIntent() {
        String screenName = "myscreenname";
        EventStreamListener listener = new EventStreamListener();

        Intent intent = new Intent(EventStreamIntentActions.VIEW_EVENT);
        intent.putExtra(EventStreamIntentExtraParams.EXTRA_EVENT_KEY, screenName);
        intent.putExtra(EventStreamIntentExtraParams.EXTRA_PLUGIN_KEY, PluginConstants.PLUGIN_IDENTIFIER);
        listener.onReceive(mContext, intent);

        // Set intent filter
        IntentFilter filter = new IntentFilter();
        filter.addAction(Intent.ACTION_VIEW);
        filter.addDataScheme("http");

        filter.addDataPath(String.format(EventStreamListener.TWITTER_STATUS_VIEW_URI, screenName),
                PatternMatcher.PATTERN_LITERAL);

        Instrumentation.ActivityMonitor monitor = new ActivityMonitor(
                filter, null, true);

        getInstrumentation().addMonitor(monitor);

        listener.onReceive(mContext, intent);

        // Verify the correct intent is launched
        assertEquals("View activty should be launched", 1, monitor.getHits());

        getInstrumentation().removeMonitor(monitor);
    }

    /**
     * Check that a valid intent return true
     */
    public void testValidateIntentValidIntent() {
        EventStreamListener listener = new EventStreamListener();
        Intent intent = new Intent(EventStreamIntentActions.VIEW_EVENT);
        intent.putExtra(EventStreamIntentExtraParams.EXTRA_PLUGIN_KEY, PluginConstants.PLUGIN_IDENTIFIER);

        boolean valid = listener.validateIntent(intent);
        assertEquals("The intent should be valid", true, valid);
    }

    /**
     * Check that a valid intent return true, check using register intent.
     * The register intent do not need to have the extra id value
     */
    public void testValidateIntentRegisterIntent() {
        EventStreamListener listener = new EventStreamListener();
        Intent intent = new Intent(EventStreamIntentActions.REGISTER);
        boolean valid = listener.validateIntent(intent);
        assertEquals("The intent should be valid", true, valid);
    }

    /**
     * Check that a valid intent return true
     */
    public void testValidateIntentIntentNull() {
        EventStreamListener listener = new EventStreamListener();
        boolean valid = listener.validateIntent(null);
        assertEquals("The intent should not be valid", false, valid);
    }

    /**
     * Check that a in-valid intent return false, extras invalid
     */
    public void testValidateIntentExtrasInvalid() {
        EventStreamListener listener = new EventStreamListener();

        // Check invalid extras
        Intent intent = new Intent(EventStreamIntentActions.VIEW_EVENT);
        intent.putExtra(EventStreamIntentExtraParams.EXTRA_PLUGIN_KEY, "");
        boolean valid = listener.validateIntent(intent);
        assertEquals("The intent should not be valid, extras empty", false, valid);

        // Check extras null
        intent.removeExtra(EventStreamIntentExtraParams.EXTRA_PLUGIN_KEY);
        valid = listener.validateIntent(intent);
        assertEquals("The intent should not be valid, extras null", false, valid);
    }

    /**
     * Check that a in-valid intent return false, no action
     */
    public void testValidateIntentNoAction() {
        EventStreamListener listener = new EventStreamListener();
        Intent intent = new Intent();
        intent.putExtra(EventStreamIntentExtraParams.EXTRA_PLUGIN_KEY, PluginConstants.PLUGIN_IDENTIFIER);

        boolean valid = listener.validateIntent(intent);
        assertEquals("The intent should not be valid", false, valid);
    }
}
