/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.provider;

import android.net.Uri;

public interface EventStreamProvider {
    public static final String AUTHORITY = "com.sonyericsson.eventstream";

    public static final String VIEW_INTENT_EXTRA_EVENT_ID = "event_id";

    public static final String VIEW_INTENT_EXTRA_SOURCE_ID = "source_id";

    public static final String REFRESH_REQUEST_INTENT = "com.sonyericsson.eventstream.REFRESH_REQUEST";

    public static final String LEGACY_REFRESH_EVENTS_INTENT = "com.sonyericsson.timescape.legacy.REFRESH_EVENTS";

    public static final String LEGACY_SCAN_PLUGINS_INTENT = "com.sonyericsson.timescape.legacy.SCAN_PLUGINS";

    public static final String VIEW_EVENT_INTENT = "com.sonyericsson.eventstream.VIEW_EVENT_INTENT";

    public class Tables {
        public static final String PLUGINS = "plugins";

        public static final String SOURCES = "sources";

        public static final String EVENTS = "events";

        public static final String FRIENDS = "friends";
    }

    public class URIs {
        public static final Uri PLUGINS = Uri
                .parse("content://" + AUTHORITY + "/" + Tables.PLUGINS);

        public static final Uri SOURCES = Uri
                .parse("content://" + AUTHORITY + "/" + Tables.SOURCES);

        public static final Uri EVENTS = Uri.parse("content://" + AUTHORITY + "/" + Tables.EVENTS);

        public static final Uri FRIENDS = Uri
                .parse("content://" + AUTHORITY + "/" + Tables.FRIENDS);
    }

    public class Plugin {
        public static final String COLUMN_FRIENDLY_NAME = "name";

        public static final String COLUMN_ICON = "icon_uri";

        public static final String COLUMN_CONFIG = "config_activity";

        public static final String COLUMN_API_VERSION = "api_version";

        public static final String COLUMN_CONFIGURATION_STATE = "config_state";
    }

    public class Event {
        public static final String COLUMN_SOURCE_ID = "source_id";

        public static final String COLUMN_MESSAGE = "message";

        public static final String COLUMN_IMAGE_URI = "image_uri";

        public static final String COLUMN_PUBLISHED_TIME = "published_time";

        public static final String COLUMN_FRIEND_KEY = "friend_key";

        public static final String COLUMN_PERSONAL = "personal";

        public static final String COLUMN_OUTGOING = "outgoing";

        public static final String COLUMN_TITLE = "title";

        public static final String COLUMN_STATUS_ICON_URI = "status_icon_uri";
    }

    public class Source {
        public static final String COLUMN_NAME = "name";

        public static final String COLUMN_ICON = "icon_uri";

        public static final String COLUMN_ENABLED = "enabled";
    }

    public class Friend {
        public static final String COLUMN_SOURCE_ID = "source_id";
        public static final String COLUMN_FRIEND_KEY ="friend_key";
        public static final String COLUMN_CONTACT_RAW_ID = "contacts_reference";
    }

    public class ConfigState {
        public static final int CONFIGURED = 0;

        public static final int NOT_CONFIGURED = 1;

        public static final int CONFIGURATION_NOT_NEEDED = 2;
    }
}
