/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import twitter4j.DirectMessage;
import twitter4j.DirectMessageJSONImpl;
import twitter4j.Status;
import twitter4j.StatusJSONImpl;
import twitter4j.StatusStreamImpl;
import twitter4j.StreamListener;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.UserJSONImpl;
import twitter4j.UserList;
import twitter4j.UserListJSONImpl;
import twitter4j.internal.async.Dispatcher;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.logging.Logger;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.json.JSONObjectType;

abstract class AbstractStreamImplementation {
    protected static final Logger logger = Logger.getLogger(StatusStreamImpl.class);
    private boolean streamAlive = true;
    private BufferedReader br;
    private InputStream is;
    private HttpResponse response;
    protected final Dispatcher dispatcher;

    AbstractStreamImplementation(Dispatcher dispatcher, InputStream stream) throws IOException {
        this.is = stream;
        this.br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        this.dispatcher = dispatcher;
    }

    AbstractStreamImplementation(Dispatcher dispatcher, HttpResponse response) throws IOException {
        this(dispatcher, response.asStream());
        this.response = response;
    }

    protected String parseLine(String line) {
        return line;
    }

    abstract void next(StreamListener[] var1) throws TwitterException;

    protected void handleNextElement() throws TwitterException {
        block6: {
            if (!this.streamAlive) {
                throw new IllegalStateException("Stream already closed.");
            }
            try {
                String line = this.br.readLine();
                if (null == line) {
                    throw new IOException("the end of the stream has been reached");
                }
                this.dispatcher.invokeLater(new StreamEvent(line){

                    public void run() {
                        this.line = AbstractStreamImplementation.this.parseLine(this.line);
                        if (this.line.length() > 0) {
                            logger.debug("received:", this.line);
                            try {
                                JSONObject json = new JSONObject(this.line);
                                JSONObjectType jsonObjectType = JSONObjectType.determine(json);
                                if (JSONObjectType.SENDER == jsonObjectType) {
                                    AbstractStreamImplementation.this.onSender(json);
                                } else if (JSONObjectType.STATUS == jsonObjectType) {
                                    AbstractStreamImplementation.this.onStatus(json);
                                } else if (JSONObjectType.DIRECT_MESSAGE == jsonObjectType) {
                                    AbstractStreamImplementation.this.onDirectMessage(json);
                                } else if (JSONObjectType.DELETE == jsonObjectType) {
                                    AbstractStreamImplementation.this.onDelete(json);
                                } else if (JSONObjectType.LIMIT == jsonObjectType) {
                                    AbstractStreamImplementation.this.onLimit(json);
                                } else if (JSONObjectType.SCRUB_GEO == jsonObjectType) {
                                    AbstractStreamImplementation.this.onScrubGeo(json);
                                } else if (JSONObjectType.FRIENDS == jsonObjectType) {
                                    AbstractStreamImplementation.this.onFriends(json);
                                } else if (JSONObjectType.FAVORITE == jsonObjectType) {
                                    AbstractStreamImplementation.this.onFavorite(json.getJSONObject("source"), json.getJSONObject("target"), json.getJSONObject("target_object"));
                                } else if (JSONObjectType.UNFAVORITE == jsonObjectType) {
                                    AbstractStreamImplementation.this.onUnfavorite(json.getJSONObject("source"), json.getJSONObject("target"), json.getJSONObject("target_object"));
                                } else if (JSONObjectType.RETWEET == jsonObjectType) {
                                    AbstractStreamImplementation.this.onRetweet(json.getJSONObject("source"), json.getJSONObject("target"), json.getJSONObject("target_object"));
                                } else if (JSONObjectType.FOLLOW == jsonObjectType) {
                                    AbstractStreamImplementation.this.onFollow(json.getJSONObject("source"), json.getJSONObject("target"));
                                } else if (JSONObjectType.USER_LIST_SUBSCRIBED == jsonObjectType) {
                                    AbstractStreamImplementation.this.onUserListSubscribed(json.getJSONObject("source"), json.getJSONObject("target"), json.getJSONObject("target_object"));
                                } else if (JSONObjectType.USER_LIST_CREATED == jsonObjectType) {
                                    AbstractStreamImplementation.this.onUserListCreated(json.getJSONObject("source"), json.getJSONObject("target"));
                                } else if (JSONObjectType.USER_LIST_UPDATED == jsonObjectType) {
                                    AbstractStreamImplementation.this.onUserListUpdated(json.getJSONObject("source"), json.getJSONObject("target"));
                                } else if (JSONObjectType.USER_LIST_DESTROYED == jsonObjectType) {
                                    AbstractStreamImplementation.this.onUserListDestroyed(json.getJSONObject("source"), json.getJSONObject("target"));
                                } else if (JSONObjectType.USER_UPDATE == jsonObjectType) {
                                    AbstractStreamImplementation.this.onUserUpdate(json.getJSONObject("source"), json.getJSONObject("target"));
                                } else if (JSONObjectType.BLOCK == jsonObjectType) {
                                    AbstractStreamImplementation.this.onBlock(json.getJSONObject("source"), json.getJSONObject("target"));
                                } else if (JSONObjectType.UNBLOCK == jsonObjectType) {
                                    AbstractStreamImplementation.this.onUnblock(json.getJSONObject("source"), json.getJSONObject("target"));
                                } else {
                                    logger.info("Received unknown event: " + this.line);
                                }
                            }
                            catch (Exception ex) {
                                AbstractStreamImplementation.this.onException(ex);
                            }
                        }
                    }
                });
            }
            catch (IOException ioe) {
                try {
                    this.is.close();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                boolean isUnexpectedException = this.streamAlive;
                this.streamAlive = false;
                if (!isUnexpectedException) break block6;
                throw new TwitterException("Stream closed.", ioe);
            }
        }
    }

    protected void onSender(JSONObject json) throws TwitterException {
    }

    protected void onStatus(JSONObject json) throws TwitterException {
    }

    protected void onDirectMessage(JSONObject json) throws TwitterException, JSONException {
    }

    protected void onDelete(JSONObject json) throws TwitterException, JSONException {
    }

    protected void onLimit(JSONObject json) throws TwitterException, JSONException {
    }

    protected void onScrubGeo(JSONObject json) throws TwitterException, JSONException {
    }

    protected void onFriends(JSONObject json) throws TwitterException, JSONException {
    }

    protected void onFavorite(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
    }

    protected void onUnfavorite(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
    }

    protected void onRetweet(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
    }

    protected void onFollow(JSONObject source, JSONObject target) throws TwitterException {
    }

    protected void onUserListSubscribed(JSONObject source, JSONObject owner, JSONObject userList) throws TwitterException, JSONException {
    }

    protected void onUserListCreated(JSONObject source, JSONObject userList) throws TwitterException, JSONException {
    }

    protected void onUserListUpdated(JSONObject source, JSONObject userList) throws TwitterException, JSONException {
    }

    protected void onUserListDestroyed(JSONObject source, JSONObject userList) throws TwitterException {
    }

    protected void onUserUpdate(JSONObject source, JSONObject target) throws TwitterException {
    }

    protected void onBlock(JSONObject source, JSONObject target) throws TwitterException {
    }

    protected void onUnblock(JSONObject source, JSONObject target) throws TwitterException {
    }

    protected void onException(Exception e) {
    }

    public void close() throws IOException {
        this.streamAlive = false;
        this.is.close();
        this.br.close();
        if (null != this.response) {
            this.response.disconnect();
        }
    }

    protected Status asStatus(JSONObject json) throws TwitterException {
        StatusJSONImpl status = new StatusJSONImpl(json);
        DataObjectFactoryUtil.registerJSONObject(status, json);
        return status;
    }

    protected DirectMessage asDirectMessage(JSONObject json) throws TwitterException {
        DirectMessageJSONImpl directMessage = null;
        try {
            directMessage = new DirectMessageJSONImpl(json.getJSONObject("direct_message"));
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
        DataObjectFactoryUtil.registerJSONObject(directMessage, json);
        return directMessage;
    }

    protected int[] asFriendList(JSONObject json) throws TwitterException {
        JSONArray friends = null;
        try {
            friends = json.getJSONArray("friends");
            int[] friendIds = new int[friends.length()];
            for (int i = 0; i < friendIds.length; ++i) {
                friendIds[i] = friends.getInt(i);
            }
            return friendIds;
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    protected User asUser(JSONObject json) throws TwitterException {
        UserJSONImpl user = new UserJSONImpl(json);
        DataObjectFactoryUtil.registerJSONObject(user, json);
        return user;
    }

    protected UserList asUserList(JSONObject json) throws TwitterException {
        UserListJSONImpl userList = new UserListJSONImpl(json);
        DataObjectFactoryUtil.registerJSONObject(userList, json);
        return userList;
    }

    abstract class StreamEvent
    implements Runnable {
        String line;

        StreamEvent(String line) {
            this.line = line;
        }
    }
}

