/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

/**
 * @file FunctionalTestRunner.java
 *
 * @author Mattias Hansson (mattias.hansson@sonyericsson.com)
 */

package com.sonyericsson.eventstream.twitterplugin.runners;

import android.test.InstrumentationTestRunner;
import android.test.InstrumentationTestSuite;

import com.sonyericsson.eventstream.twitterplugin.service.FTwitterPluginServiceTests;
import com.sonyericsson.eventstream.twitterplugin.view.FConfigurationActivityTests;

import junit.framework.TestSuite;

public class FunctionalTestRunner extends InstrumentationTestRunner {

    @Override
    public TestSuite getAllTests() {
        TestSuite suite = new InstrumentationTestSuite(this);
        suite.addTestSuite(FConfigurationActivityTests.class);
        suite.addTestSuite(FTwitterPluginServiceTests.class);
        return suite;
    }

    @Override
    public ClassLoader getLoader() {
        return FunctionalTestRunner.class.getClassLoader();
    }
}