/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

/**
 * @auth Erik Hellman <erik.hellman@sonyericsson.com>
 */
@RunWith(PowerMockRunner.class)
@PrepareForTest({Activity.class, Uri.class, Intent.class, Bundle.class})
public class TestTwitterView {

    @Test
    public void testLaunchTwitterWebClient() throws Exception {
/**        String eventId = "123456";
        String friendId = "7654321";
        PowerMock.suppress(Activity.class.getConstructors());

        // Mock objects
        TwitterViewLauncher twitterViewLauncher = PowerMock.createPartialMock(TwitterViewLauncher.class, "startActivity", "getIntent", "finish");
        Intent intent = PowerMock.createMock(Intent.class);
        Intent webViewIntent = PowerMock.createMock(Intent.class);
        Bundle extra = PowerMock.createMock(Bundle.class);
        Uri webViewUri = PowerMock.createMock(Uri.class);
        PowerMock.mockStatic(Uri.class);

        EasyMock.expect(twitterViewLauncher.getIntent()).andReturn(intent).once();
        EasyMock.expect(intent.getExtras()).andReturn(extra).times(2);
        EasyMock.expect(extra.getString(PluginConstants.EVENTSTREAM_VIEW_EVENT_ID_EXTRA)).andReturn(eventId).once();
        EasyMock.expect(extra.getString(PluginConstants.EVENTSTREAM_VIEW_FRIEND_ID_EXTRA)).andReturn(friendId).once();
        PowerMock.expectNew(Intent.class, Intent.ACTION_VIEW).andReturn(webViewIntent).once();
        EasyMock.expect(Uri.parse(TwitterViewLauncher.TWITTER_STATUS_VIEW_URI)).andReturn(webViewUri).once();
        EasyMock.expect(Uri.withAppendedPath(webViewUri, friendId)).andReturn(webViewUri).once();
        EasyMock.expect(Uri.withAppendedPath(webViewUri, "status")).andReturn(webViewUri).once();
        EasyMock.expect(Uri.withAppendedPath(webViewUri, eventId)).andReturn(webViewUri).once();
        EasyMock.expect(webViewIntent.setData(webViewUri)).andReturn(webViewIntent).once();
        twitterViewLauncher.startActivity(webViewIntent);
        twitterViewLauncher.finish();
        PowerMock.expectLastCall().once();

        PowerMock.replayAll();
        Whitebox.invokeMethod(twitterViewLauncher, "launchTwitterWebClient");
        PowerMock.verifyAll();*/
    }

    @Test
    public void testInvalidLaunchTwitterWebClient() throws Exception {
/**        String eventId = null;
        String friendId = "7654321";
        PowerMock.suppress(Activity.class.getConstructors());

        // Mock objects
        TwitterViewLauncher twitterViewLauncher = PowerMock.createPartialMock(TwitterViewLauncher.class, "startActivity", "getIntent", "finish");
        Intent intent = PowerMock.createMock(Intent.class);
        Intent webViewIntent = PowerMock.createMock(Intent.class);
        Bundle extra = PowerMock.createMock(Bundle.class);
        Uri webViewUri = PowerMock.createMock(Uri.class);
        PowerMock.mockStatic(Uri.class);

        EasyMock.expect(twitterViewLauncher.getIntent()).andReturn(intent).once();
        EasyMock.expect(intent.getExtras()).andReturn(extra).times(2);
        EasyMock.expect(extra.getString(PluginConstants.EVENTSTREAM_VIEW_EVENT_ID_EXTRA)).andReturn(eventId).once();
        EasyMock.expect(extra.getString(PluginConstants.EVENTSTREAM_VIEW_FRIEND_ID_EXTRA)).andReturn(friendId).once();
        twitterViewLauncher.finish();

        PowerMock.replayAll();
        Whitebox.invokeMethod(twitterViewLauncher, "launchTwitterWebClient");
        PowerMock.verifyAll();*/
    }
}
