/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/
package com.sonyericsson.eventstream.twitterplugin.twitter;

import android.util.Log;

import com.sonyericsson.eventstream.twitterplugin.PluginConstants.Config;

import java.lang.reflect.Method;


public class CredentialHandler {

    /** Twitter application key */
    public static final int TWITTER_API_KEY = 1;

    /** Twitter secret key */
    public static final int TWITTER_SECRET_KEY = 2;

    /** This instance */
    private static CredentialHandler mInstance = null;

    /** The api key set to use */
    private String mApiKeySet = null;

    /** Timescape api key set system property */
    private static final String RO_SEMC_TIMESCAPE_KEYS = "ro.semc.timescape_keys";

    /** Emulator product model */
    private static final String EMULATOR_MODEL =  "sdk";

    /** SEMC emulator product model */
    private static final String SEMC_EMULATOR_MODEL =  "semcsdk";

    /** Emulator product model eDream */
    private static final String MANUFACTURER =  "Sony Ericsson";

    /*********************************************************************
     * Encrypted API keys
     *********************************************************************/

    /** Play product model */
    private static final String PLAY_PRODUCT_MODEL =  "Sony_Ericsson_Xperia_PLAY";

    /** Play product model twitter app key */
    private static final String PLAY_PRODUCT_MODEL_TWITTER_API_KEY =
        "8a947b14b5cf75652b1b2c769df6091edbde74b013d22f5b5d764ba6101687981f6816e971ca111eb834a3ba83ad242";

    /** Play product model twitter secret key */
    private static final String PLAY_PRODUCT_MODEL_TWITTER_SECRET_KEY =
        "-559420cbbfbc8ded93275fe9d433dcefe60e460dccceac1b552bcd95f6bff42a52a4ca3ddfebccae0e4ba8256447069bd8bdfb67f1097646070d59a21713d00e7e097e9168e35eee147cb5c457c52dbe";


    /** Generic product model */
    private static final String GENERIC_PRODUCT_MODEL =  "Sony_Ericsson_Xperia";

    /** Generic product model twitter app key */
    private static final String GENERIC_PRODUCT_MODEL_TWITTER_API_KEY =
        "6000a223122834241ba97f1492a10c66509505fbe69d45a7c4a3d2c9d2696f9381f6816e971ca111eb834a3ba83ad242";

    /** Generic product model twitter secret key */
    private static final String GENERIC_PRODUCT_MODEL_TWITTER_SECRET_KEY =
        "4637a6ceb1a697667871f6957d8dd4561b444643d49b0a1caa53dc8e8c134837fb9758e32130c2df567bb5068b573870274204980ef689b9f8f2a65de8ec2ff181f6816e971ca111eb834a3ba83ad242";


    /** Developer product model */
    private static final String DEV_PRODUCT_MODEL =  "dev_key";

    /** Developer twitter api key */
    private static final String DEV_TWITTER_API_KEY =
        "-482643ab312bcb4c296b3d050138f91bc5ca4c3988021d91863fba7878b318927e097e9168e35eee147cb5c457c52dbe";

    /** Developer twitter secret key */
    private static final String DEV_TWITTER_SECRET_KEY =
        "a788d50be1b1492d65100cc1ee0d1aa371d5c50b1b0299b6042ca572c4021bef6d050c14ee6a8c3463543dff7a9b0f5274204980ef689b9f8f2a65de8ec2ff181f6816e971ca111eb834a3ba83ad242";

    /**
     * List of all supported api keys in the format {model,
     * twitter api key, twitter secret key}
     */
    private static final String[][] mApiKeys = {
        {
                DEV_PRODUCT_MODEL,
                DEV_TWITTER_API_KEY,
                DEV_TWITTER_SECRET_KEY
        },
        {
                PLAY_PRODUCT_MODEL,
                PLAY_PRODUCT_MODEL_TWITTER_API_KEY,
                PLAY_PRODUCT_MODEL_TWITTER_SECRET_KEY
        },
        {
                GENERIC_PRODUCT_MODEL,
                GENERIC_PRODUCT_MODEL_TWITTER_API_KEY,
                GENERIC_PRODUCT_MODEL_TWITTER_SECRET_KEY
        }
    };

    /** System property method used by reflection */
    private static Method mSystemPropertiesGet = null;

    public static final int NOTIFY_ID = 1;

    /**
     * Default constructor, protected so the class can be extended (can be used
     * for mocking the class in test)
     */
    protected CredentialHandler() {

        try {
            Class<?> sysProp = Class.forName("android.os.SystemProperties");
            mSystemPropertiesGet = sysProp.getMethod("get", new Class[] { String.class } );
        } catch(Exception e) {
            Log.e(Config.LOG_TAG, "Could not load the SystemProperties.get method");
        }

        if (mSystemPropertiesGet != null) {
            try {
                mApiKeySet = (String) mSystemPropertiesGet.invoke(null, RO_SEMC_TIMESCAPE_KEYS);
            } catch(Exception e) {
                Log.e(Config.LOG_TAG, "Error, not possible to invoke system properties get");
            }
        } else {
            Log.e(Config.LOG_TAG, "Error, system properties get function is null");
        }

        if (mApiKeySet == null || mApiKeySet.length() <= 0) {
            if (!android.os.Build.MANUFACTURER.equals(MANUFACTURER) &&
                !android.os.Build.MODEL.equals(EMULATOR_MODEL) &&
                !android.os.Build.MODEL.equals(SEMC_EMULATOR_MODEL) ) {
                throw new RuntimeException("System property keys not set");
            } else {
                mApiKeySet = DEV_PRODUCT_MODEL;
            }
        }
    }

    /**
     * Get an instance of this singleton.
     *
     * @return the instance of this class
     */
    public static CredentialHandler getInstance() {
        if (mInstance == null) {
            mInstance = new CredentialHandler();
        }

        return mInstance;
    }

    /**
     * Retrive an encryped api key.
     *
     * @param type sns type, valid values are
     *          TWITTER_API_KEY or TWITTER_SECRET_KEY
     * @return the encryped api key.
     * @throws IllegalArgumentException on invalid argument
     */
    public String getCredential(int type) {

        String result = null;

        for (int i = 0; i < mApiKeys.length; i++) {
            if (mApiKeys[i][0].equals(mApiKeySet)) {
                switch (type) {
                    case TWITTER_API_KEY:
                        result = mApiKeys[i][1];
                        break;
                    case TWITTER_SECRET_KEY:
                        result = mApiKeys[i][2];
                        break;
                    default:
                        throw new IllegalArgumentException("Invalid type:" + type);
                }
                break;
            }
        }

        if (result == null) {
            throw new IllegalArgumentException("Invalid sns type or api key set not declared. type:"
                    + type + " api key set:" + mApiKeySet);
        }

        return result;
    }
}
