/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.telephonyplugin.utils;

import java.lang.reflect.Field;

public class ReflectionUtilities {
    @SuppressWarnings("unchecked")
    public static Field getField(final Object instance, final String fieldName) {
        Class<?> type;
        if (instance instanceof Class) {
            type = (Class<?>)instance;
        } else {
            type = instance.getClass();
        }

        try {
            Field field = type.getDeclaredField(fieldName);
            field.setAccessible(true);

            return field;
        } catch (NoSuchFieldException e) {
            Class<?> superClass = type.getSuperclass();
            if (superClass == null) {
                return null;
            }

            return getField(superClass, fieldName);
        }
    }
}
