/*
 * Copyright (C) 2010 Sony Ericsson Mobile Communications AB.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 *
 */

package com.sonyericsson.eventstream.rssplugin;

import java.util.Date;

/**
 * Item.
 */
public class Item {

    /** The unique id of the Item. */
    private int id;

    /** The date the entry was last updated. */
    private Date date;

    /** The title of the entry. */
    private String title;

    /** The URL of the entry. */
    private String link;

    /** The description of the entry. */
    private String description;

    /** The Id of the entry. */
    private String guid;

    /** The URL of the entry's thumbnail. */
    private String mediaThumbnail;

    /**
     * @param id the id to set
     */
    public void setId(int id) {
        this.id = id;
    }

    /**
     * @return the id
     */
    public int getId() {
        return id;
    }

    /**
     * @return the time value of the date
     */
    public long getTimeOfDate() {
        return date.getTime();
    }

    /**
     * @param date the date to set
     */
    public void setTimeOfDate(long timeOfDate) {
        this.date = new Date(timeOfDate);
    }

    /**
     * @return the title
     */
    public String getTitle() {
        return title;
    }

    /**
     * @param title the title to set
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * @return the link
     */
    public String getLink() {
        return link;
    }

    /**
     * @param link the link to set
     */
    public void setLink(String link) {
        this.link = link;
    }

    /**
     * @return the description
     */
    public String getDescription() {
        return description;
    }

    /**
     * @param description the description to set
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @return the guid
     */
    public String getGuid() {
        return guid;
    }

    /**
     * @param guid the guid to set
     */
    public void setGuid(String guid) {
        this.guid = guid;
    }

    /**
     * @return the mediaThumbnail
     */
    public String getMediaThumbnail() {
        return mediaThumbnail;
    }

    /**
     * @param mediaThumbnail the mediaThumbnail to set
     */
    public void setMediaThumbnail(String mediaThumbnail) {
        this.mediaThumbnail = mediaThumbnail;
    }
}
