/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

/**
 * @file FacebookCommunication.java
 *
 * @author
 */
package com.sonyericsson.eventstream.facebookplugin;

import android.content.Context;

public class FacebookFactory {
    private static Facebook sFacebookInstance = null;
    private static FacebookSecurity sFacebookSecurityInstance = null;

    private FacebookFactory() {

    }

    public synchronized static final Facebook getFacebook(Context context) {
        if (sFacebookInstance == null) {
            sFacebookInstance = new Facebook(new Settings(context));
            sFacebookInstance.initialize();
        }
        return sFacebookInstance;
    }

    public synchronized static FacebookSecurity getFacebookSecurity() {
        if (sFacebookSecurityInstance == null) {
            sFacebookSecurityInstance = new FacebookSecurity();
        }
        return sFacebookSecurityInstance;
    }

    public synchronized static final void terminate(boolean reinitialize) {
        if (sFacebookInstance != null) {
            sFacebookInstance.shutdown();
            if (reinitialize) {
                sFacebookInstance.initialize();
            } else {
                sFacebookInstance = null;
            }
        }
        if (sFacebookSecurityInstance != null) {
            sFacebookSecurityInstance = null;
        }
    }
}