/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.esdatasourceplugin;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.widget.TextView;

public class ViewEventActivity extends Activity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.view_event_activity);

        Intent intent = getIntent();
        if(intent != null) {
            long eventId = intent.getLongExtra(EventStreamContentProvider.IntentData.EXTRA_EVENT_ID, -1);
            long sourceId = intent.getLongExtra(EventStreamContentProvider.IntentData.EXTRA_SOURCE_ID, -1);
            String eventKey = intent.getStringExtra(EventStreamContentProvider.IntentData.EXTRA_EVENT_KEY);
            String friendKey = intent.getStringExtra(EventStreamContentProvider.IntentData.EXTRA_FRIEND_KEY);
            TextView eventText = (TextView)findViewById(R.id.eventText);
            eventText.setText("Event id = " + eventId + " clicked for sourceId = " + sourceId +
                    " with eventKey = " + eventKey + " and friendKey = " + friendKey);
        }
    }

}
