/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.calllogplugin;

import com.sonyericsson.eventstream.calllogplugin.PluginConstants.Config;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.net.Uri;
import android.provider.ContactsContract;
import android.provider.ContactsContract.PhoneLookup;
import android.util.Log;

public class ContactAdapter {

    static Cursor getContact(Context context, String phonenumber) {
        Cursor cursor = null;

        Uri phoneLookupUri = Uri.withAppendedPath(
                PhoneLookup.CONTENT_FILTER_URI, Uri.encode(phonenumber));
        try {
            cursor = context.getContentResolver().query(
                    phoneLookupUri, null, null, null, null);
        } catch (SQLException e) {
            Log.w(Config.LOG_TAG, "Failed to query contacts");
            throw new RuntimeException(e);
        }

        return cursor;
    }

    static Uri getRawContactUri(Context context, long dataId) {
        Cursor cursor = null;
        long result = -1;

        try {
            ContentResolver cr = context.getContentResolver();
            Uri uri = Uri.withAppendedPath(ContactsContract.Data.CONTENT_URI, String.valueOf(dataId));

            cursor = cr.query(uri, new String[]{ContactsContract.Data.RAW_CONTACT_ID},
                    null, null, null);
            if (cursor != null && cursor.moveToNext()) {
                result = cursor.getLong(cursor.getColumnIndex(ContactsContract.Data.RAW_CONTACT_ID));
            }
        } catch (SQLException exception) {

        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (result != -1) {
            return Uri.withAppendedPath(ContactsContract.RawContacts.CONTENT_URI, String.valueOf(result));
        } else {
            return null;
        }
    }
}
