/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma;

import com.vladium.emma.AppLoggers;
import com.vladium.emma.EMMAProperties;
import com.vladium.logging.Logger;
import com.vladium.util.IProperties;
import java.util.Properties;

public abstract class Processor {
    protected String m_appName;
    protected IProperties m_propertyOverrides;
    protected Logger m_log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void run() {
        this.validateState();
        IProperties appProperties = EMMAProperties.getAppProperties();
        IProperties toolProperties = IProperties.Factory.combine(this.m_propertyOverrides, appProperties);
        Logger current = Logger.getLogger();
        Logger log = AppLoggers.create(this.m_appName, toolProperties, current);
        if (log.atTRACE1()) {
            log.trace1("run", "complete tool properties:");
            toolProperties.list(log.getWriter());
        }
        try {
            Logger.push(log);
            this.m_log = log;
            this._run(toolProperties);
            Object var5_4 = null;
            if (this.m_log == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.m_log == null) throw throwable;
            Logger.pop(this.m_log);
            this.m_log = null;
            throw throwable;
        }
        Logger.pop(this.m_log);
        this.m_log = null;
    }

    public final synchronized void setAppName(String appName) {
        this.m_appName = appName;
    }

    public final synchronized void setPropertyOverrides(Properties overrides) {
        this.m_propertyOverrides = EMMAProperties.wrap(overrides);
    }

    public final synchronized void setPropertyOverrides(IProperties overrides) {
        this.m_propertyOverrides = overrides;
    }

    protected Processor() {
    }

    protected abstract void _run(IProperties var1);

    protected void validateState() {
    }
}

