package com.example.hello.android.wifi_state_get;

import android.app.Activity;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;

public class MainActivity extends Activity
{

	private static final String LOG_TAG = "XXX";

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);
	}

	@Override
	protected void onResume()
	{
		super.onResume();
		updateWifiState();
	}

	private void updateWifiState()
	{
		Log.v(LOG_TAG, "updateWifiState() : Hello");

		WifiManager wifiManager = (WifiManager) getSystemService(WIFI_SERVICE);
		int wifiState = wifiManager.getWifiState();
		Log.d(LOG_TAG, "updateWifiState() : wifiState => " + wifiState);

		String wifiStateString = null;
		switch (wifiState)
		{
			case WifiManager.WIFI_STATE_DISABLED:
				wifiStateString = "WIFI_STATE_DISABLED";
				break;
			case WifiManager.WIFI_STATE_DISABLING:
				wifiStateString = "WIFI_STATE_DISABLING";
				break;
			case WifiManager.WIFI_STATE_ENABLED:
				wifiStateString = "WIFI_STATE_ENABLED";
				break;
			case WifiManager.WIFI_STATE_ENABLING:
				wifiStateString = "WIFI_STATE_ENABLING";
				break;
			case WifiManager.WIFI_STATE_UNKNOWN:
				wifiStateString = "WIFI_STATE_UNKNOWN";
				break;
		}
		Log.d(LOG_TAG, "updateWifiState() : wifiStateString => " + wifiStateString);

		TextView wifiStateTextView = (TextView) findViewById(R.id.wifi_state_text);
		wifiStateTextView.setText(wifiStateString);

		Log.v(LOG_TAG, "updateWifiState() : Bye");
	}
}
