/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package com.example.hello.android.view_custom_drawing_hello;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.Log;
import android.view.View;

/**
 *
 * @author sawai
 */
public class LinesView extends View
{

	private Paint bgPaint;
	private Paint fgPaint;

	public LinesView(Context context)
	{
		super(context);
		Log.d("CanvasView", "new CanvasView()");
		bgPaint = new Paint();
		bgPaint.setColor(Color.WHITE);
		fgPaint = new Paint();
		fgPaint.setColor(Color.BLACK);
		fgPaint.setAntiAlias(true);
	}

	@Override
	protected void onDraw(Canvas canvas)
	{
		super.onDraw(canvas);
		Log.d("CanvasView", "onDraw()");

		int w = canvas.getWidth();
		int h = canvas.getHeight();

		// clear canvas
		canvas.drawRect(0, 0, w, h, bgPaint);

		// draw lines
		int x1, x2;
		int y1 = 0;
		int y2 = h - 1;
		for (int i = 0; i <= 20; i++)
		{
			x1 = w * i / 20;
			x2 = w - x1;
			canvas.drawLine(x1, y1, x2, y2, fgPaint);
		}
	}
}
