/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.ui_pattern_listview_detail_editor;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;

public class EditNameActivity extends Activity
	implements OnClickListener
{

	public static final String EXTRA_USER_NAME = EditNameActivity.class.getPackage().getName() + ".EXTRA_USER_NAME";
	private EditText nameEditText;
	private Button okButton;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.edit_name_activity);

		getWindow().setSoftInputMode(
			WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_VISIBLE
			| WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);

		okButton = (Button) findViewById(R.id.ok_button);
		nameEditText = (EditText) findViewById(R.id.name_edittext);
		okButton.setOnClickListener(this);

		Intent intent = getIntent();
		String userName = intent.getStringExtra(EXTRA_USER_NAME);
		if (userName != null)
		{
			nameEditText.setText(userName);
		}

	}

	public void onClick(View v)
	{
		switch (v.getId())
		{
			case R.id.ok_button:
				String name = nameEditText.getText().toString();
				Intent resultIntent = new Intent();
				resultIntent.putExtra(EXTRA_USER_NAME, name);
				setResult(RESULT_OK, resultIntent);
				finish();
				break;
			default:
				throw new AssertionError();
		}
	}
}
