/*
 *  The MIT License
 *
 *  Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package com.example.hello.android.ui_pattern_listview_crud_db;

import android.app.Activity;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.example.hello.android.ui_pattern_listview_crud_db.db.UserDBConstants;
import com.example.hello.android.ui_pattern_listview_crud_db.db.UserDBHelper;

public class UserDetailEditActivity extends Activity
	implements View.OnClickListener
{
	public static final String EXTRA_ID = "ID";
	private static final String LOG_TAG = "XXX";
	private UserDBHelper dbHelper;
	private SQLiteDatabase db;
	private long dataId;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "onCreate() : Hello");
		super.onCreate(savedInstanceState);
		setContentView(R.layout.user_detail_edit_activity);

		initializeDB();

		// init views
		Intent intent = getIntent();
		dataId = intent.getLongExtra(EXTRA_ID, -1);
		Log.d(LOG_TAG, "dataId => " + dataId);
		if (dataId >= 0)
		{
			loadData(dataId);
		}

		Button saveButton = (Button) findViewById(R.id.save_button);
		saveButton.setOnClickListener(this);

		Button cancelButton = (Button) findViewById(R.id.cancel_button);
		cancelButton.setOnClickListener(this);

		Log.v(LOG_TAG, "onCreate() : Bye");
	}

	@Override
	protected void onDestroy()
	{
		Log.v(LOG_TAG, "onCreate() : Hello");

		finalizeDB();
		super.onDestroy();

		Log.v(LOG_TAG, "onCreate() : Bye");
	}

	public void onClick(View view)
	{
		Log.v(LOG_TAG, "onClick() : Hello");

		int viewId = view.getId();
		if (viewId == R.id.save_button)
		{
			Log.d(LOG_TAG, "onClick() : Save Button is clicked.");
			saveUserData();
			setResult(Activity.RESULT_OK);
			finish();
		}
		else if (viewId == R.id.cancel_button)
		{
			Log.d(LOG_TAG, "onClick() : Cancel Button is clicked.");
			setResult(Activity.RESULT_CANCELED);
			finish();
		}

		Log.v(LOG_TAG, "onClick() : Bye");
	}

	/*
	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
	Log.v(LOG_TAG, "onActivityResult() : Hello");
	if (requestCode == REQUEST_CODE_EDIT_USER && resultCode == RESULT_OK)
	{
	Log.d(LOG_TAG, "onActivityResult() : User edit is done.");
	int id = data.getIntExtra(UserDetailActivity.EXTRA_ID, -1);
	if (id != -1)
	{
	loadData(id);
	}
	}
	Log.v(LOG_TAG, "onActivityResult() : Bye");
	}
	 */
	private void initializeDB()
	{
		dbHelper = new UserDBHelper(this);
		db = dbHelper.getReadableDatabase();
	}

	private void finalizeDB()
	{

		if (db != null)
		{
			db.close();
			db = null;
		}
		if (dbHelper != null)
		{
			dbHelper.close();
			dbHelper = null;
		}

	}

	private void loadData(long id)
	{
		Log.v(LOG_TAG, "loadData() : Hello");
		Log.v(LOG_TAG, "loadData() : id => " + id);

		Cursor cursor = dbHelper.selectUsersById(db, id);
		try
		{
			Log.d(LOG_TAG, "loadData() : cursor => " + cursor);
			if (cursor.moveToFirst())
			{
				String firstName = cursor.getString(cursor.getColumnIndex(UserDBConstants.Columns.FIRST_NAME));
				Log.d(LOG_TAG, "loadData() : firstName => " + firstName);
				String lastName = cursor.getString(cursor.getColumnIndex(UserDBConstants.Columns.LAST_NAME));
				String email = cursor.getString(cursor.getColumnIndex(UserDBConstants.Columns.EMAIL));
				int age = cursor.getInt(cursor.getColumnIndex(UserDBConstants.Columns.AGE));

				TextView firstNameTextView = (TextView) findViewById(R.id.first_name_textview);
				TextView lastNameTextView = (TextView) findViewById(R.id.last_name_textview);
				TextView emailTextView = (TextView) findViewById(R.id.email_textview);
				TextView ageTextView = (TextView) findViewById(R.id.age_textview);

				firstNameTextView.setText(firstName);
				lastNameTextView.setText(lastName);
				emailTextView.setText(email);
				if (age != -1)
				{
					ageTextView.setText(String.valueOf(age));
				}
			}
		}
		finally
		{
			cursor.close();
		}

		Log.v(LOG_TAG, "loadData() : Bye");
	}

	private void saveUserData()
	{
		TextView firstNameTextView = (TextView) findViewById(R.id.first_name_textview);
		TextView lastNameTextView = (TextView) findViewById(R.id.last_name_textview);
		TextView emailTextView = (TextView) findViewById(R.id.email_textview);
		TextView ageTextView = (TextView) findViewById(R.id.age_textview);

		String firstName = firstNameTextView.getText().toString();
		String lastName = lastNameTextView.getText().toString();
		String email = emailTextView.getText().toString();
		String ageString = ageTextView.getText().toString();
		int age;
		try
		{
			age = Integer.parseInt(ageString);
		}
		catch (NumberFormatException e)
		{
			age = 0;
		}

		if (dataId < 0)
		{
			dbHelper.insertUser(db, firstName, lastName, email, age);
		}
		else
		{
			dbHelper.updateUserById(db, dataId, firstName, lastName, email, age);
		}
	}
}
