/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.service_start_at_boottime;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.Toast;

public class MainActivity extends Activity implements OnClickListener
{

	private ComponentName serviceComponentName;

	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		Button startServiceButton = (Button) findViewById(R.id.start_service_button);
		startServiceButton.setOnClickListener(this);
		Button stopServiceButton = (Button) findViewById(R.id.stop_service_button);
		stopServiceButton.setOnClickListener(this);
	}

	public void onClick(View view)
	{
		switch (view.getId())
		{
			case R.id.start_service_button:
				if (serviceComponentName == null)
				{
					Toast.makeText(getApplicationContext(), "Start Service!", Toast.LENGTH_SHORT).show();
					Intent intent = new Intent(MainActivity.this, CountUpService.class);
					serviceComponentName = startService(intent);
				}

				break;
			case R.id.stop_service_button:
				if (serviceComponentName != null)
				{
					Toast.makeText(getApplicationContext(), "Stop Service!", Toast.LENGTH_SHORT).show();
					Intent intent = new Intent();
					intent.setComponent(serviceComponentName);
					stopService(intent);
					serviceComponentName = null;
				}

				break;
		}
	}
}
