/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.service_start_at_boottime;

import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.util.Log;

public class CountUpService extends Service
	implements Runnable
{
	private static final long COUNT_INTERVAL_MSEC = 1000; // 1 (sec)
	private Handler handler;
	private boolean running;
	private int count;

	@Override
	public void onCreate()
	{
		Log.d("CountUpService", "onCreate()");
		super.onCreate();
		handler = new Handler();
		running = false;
	}

	@Override
	public void onDestroy()
	{
		Log.d("CountUpService", "onDestroy()");
		running = false;
		super.onDestroy();
	}

	@Override
	public void onStart(Intent intent, int startId)
	{
		Log.d("CountUpService", "onStart()");
		super.onStart(intent, startId);
		if (!running)
		{
			running = true;
			count = 0;
			handler.postDelayed(this, COUNT_INTERVAL_MSEC);
		}
	}

	@Override
	public IBinder onBind(Intent arg0)
	{
		Log.d("CountUpService", "onBind()");
		return null;
	}

	public void run()
	{
		Log.d("CountUpService", "run() count : " + count);
		if (running)
		{
			count++;
			handler.postDelayed(this, COUNT_INTERVAL_MSEC);
		}
	}
}
