/*
 * The MIT License
 *
 * Copyright 2012 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.searchview_recent_query_suggestion.db;

import android.content.ContentValues;
import android.content.SearchRecentSuggestionsProvider;
import android.database.Cursor;
import android.net.Uri;
import com.example.hello.android.searchview_recent_query_suggestion.util.Log;
import java.util.Map.Entry;
import java.util.Set;

/**
 * 最近使った検索ワードをサジェスチョンする。
 *
 * 最近使った検索ワードを保存しておいて、それを提案する検索サジェスチョン用のコンテントプロバイダ。 実際使う場合はコンストラクタの
 * setupSuggestions(AUTHORITY,DATABASE_MODE_QUERIES);
 * の呼び出しだけでよい。オーバーライドしている他のメソッドはすべて動作確認用のログ。
 *
 * @author Masahiko, SAWAI <masahiko.sawai@gmail.com>
 */
public class UserSearchRecentSuggestionProvider extends SearchRecentSuggestionsProvider
{

	private static final String LOG_TAG = "XXX";
	public static final String AUTHORITY = "com.example.hello.android.searchview_recent_query_suggestion_provider";

	public UserSearchRecentSuggestionProvider()
	{
		Log.v(LOG_TAG, "Hello");
		setupSuggestions(AUTHORITY, DATABASE_MODE_QUERIES);
		Log.v(LOG_TAG, "Bye");
	}

	@Override
	public String getType(Uri uri)
	{
		Log.v(LOG_TAG, "Hello");

		Log.v(LOG_TAG, "uri => " + uri);
		String type = super.getType(uri);
		Log.v(LOG_TAG, "type => " + type);

		Log.v(LOG_TAG, "Bye");
		return type;
	}

	@Override
	public Uri insert(Uri uri, ContentValues values)
	{
		Log.v(LOG_TAG, "Hello");

		Log.v(LOG_TAG, "uri => " + uri);
		Set<Entry<String, Object>> valueSet = values.valueSet();
		Log.v(LOG_TAG, "valueSet.size => " + valueSet.size());

		for (Entry<String, Object> entry : valueSet)
		{
			Log.v(LOG_TAG, "valueSet key => " + entry.getKey());
			Log.v(LOG_TAG, "valueSet value => " + entry.getValue());
		}

		Uri result = super.insert(uri, values);

		Log.v(LOG_TAG, "Bye");
		return result;
	}

	@Override
	public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder)
	{
		Log.v(LOG_TAG, "Hello");

		Log.v(LOG_TAG, "uri => " + uri);
		Log.v(LOG_TAG, "projection => " + projection);
		if (projection != null)
		{
			for (String proj : projection)
			{
				Log.v(LOG_TAG, "proj => " + proj);
			}
		}
		Log.v(LOG_TAG, "selection => " + selection);
		Log.v(LOG_TAG, "selectionArgs => " + selectionArgs);
		if (selectionArgs != null)
		{
			for (String arg : selectionArgs)
			{
				Log.v(LOG_TAG, "arg => " + arg);
			}
		}
		Log.v(LOG_TAG, "sortOrder => " + sortOrder);
		Cursor cursor = super.query(uri, projection, selection, selectionArgs, sortOrder);

		String[] columnNames = cursor.getColumnNames();
		Log.v(LOG_TAG, "columnNames => " + columnNames);
		if (columnNames != null)
		{
			for (String columnName : columnNames)
			{
				Log.v(LOG_TAG, "columnName => " + columnName);
			}
		}

		Log.v(LOG_TAG, "Bye");
		return cursor;
	}
}
