/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.activity_manager_running_app_processes_list;

import android.app.ActivityManager;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppProcessListAdapter extends ArrayAdapter<ActivityManager.RunningAppProcessInfo>
{

	private LayoutInflater inflater;
	private static final String LOG_TAG = "XXX";
	private static final Map<Integer, String> IMPORTANCE_NAME_MAP = new HashMap<Integer, String>();
	private static final Map<Integer, String> REASON_NAME_MAP = new HashMap<Integer, String>();
	private static Field IMPORTANCE_REASON_CODE_FIELD = null; // RunningAppProcessInfo.importanceReasonCode is available in API Level 5 or later

	static
	{
		Field[] declaredFields = ActivityManager.RunningAppProcessInfo.class.getDeclaredFields();

		for (Field field : declaredFields)
		{
			try
			{
				String name = field.getName();
				if (name.startsWith("IMPORTANCE_"))
				{
					int value = field.getInt(null);
					IMPORTANCE_NAME_MAP.put(value, name);
				}
				else if (name.startsWith("REASON_"))
				{
					int value = field.getInt(null);

					Log.d(LOG_TAG, "reason name => " + name + ", value => " + value);
					REASON_NAME_MAP.put(value, name);
				}
			}
			catch (IllegalArgumentException ex)
			{
				Log.e(LOG_TAG, "Error", ex);
			}
			catch (IllegalAccessException ex)
			{
				Log.e(LOG_TAG, "Error", ex);
			}
		}

		try
		{
			IMPORTANCE_REASON_CODE_FIELD = ActivityManager.RunningAppProcessInfo.class.getField("importanceReasonCode");
		}
		catch (NoSuchFieldException ex)
		{
			Log.e(LOG_TAG, "Error", ex);
		}
		catch (SecurityException ex)
		{
			Log.e(LOG_TAG, "Error", ex);
		}
	}

	public AppProcessListAdapter(Context context, List<ActivityManager.RunningAppProcessInfo> taskList)
	{
		super(context, 0, taskList);
		inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent)
	{
		View view;

		if (convertView == null)
		{
			view = inflater.inflate(R.layout.app_process_list_item, null);
		}
		else
		{
			view = convertView;
		}

		ActivityManager.RunningAppProcessInfo appProcessInfo = getItem(position);
		if (appProcessInfo != null)
		{

			TextView processNameTextView = (TextView) view.findViewById(R.id.process_name_textview);
			processNameTextView.setText(appProcessInfo.processName);

			TextView importanceTextView = (TextView) view.findViewById(R.id.importance_textview);
			String importanceText = IMPORTANCE_NAME_MAP.get(appProcessInfo.importance);
			importanceTextView.setText(importanceText);

			TextView importanceReasonTextView = (TextView) view.findViewById(R.id.importance_reason_textview);
			if (IMPORTANCE_REASON_CODE_FIELD == null)
			{
				importanceReasonTextView.setVisibility(View.GONE);
			}
			else
			{
				importanceReasonTextView.setVisibility(View.VISIBLE);
				try
				{
					int importanceReasonCode = IMPORTANCE_REASON_CODE_FIELD.getInt(appProcessInfo);
					String importanceReasonText = REASON_NAME_MAP.get(importanceReasonCode);
					importanceReasonTextView.setText(importanceReasonText);
				}
				catch (IllegalArgumentException ex)
				{
				}
				catch (IllegalAccessException ex)
				{
				}
			}

			TextView pidTextView = (TextView) view.findViewById(R.id.pid_textview);
			pidTextView.setText(String.valueOf(appProcessInfo.pid));

			TextView lruTextView = (TextView) view.findViewById(R.id.lru_textview);
			lruTextView.setText(String.valueOf(appProcessInfo.lru));
		}
		return view;
	}
}
