/*
 * The MIT License
 *
 * Copyright 2012-2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.actionmode_listview_in_fragment;

import android.app.ListFragment;
import android.content.res.Resources;
import android.os.Bundle;
import android.util.Log;
import android.view.ActionMode;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView.MultiChoiceModeListener;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UserListFragment extends ListFragment
{

	private static final String LOG_TAG = "XXX";
	private List<String> userListData = new ArrayList<String>();
	private ArrayAdapter userListAdapter;

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState)
	{
		View view = inflater.inflate(R.layout.user_list_fragment, null);

		return view;
	}

	@Override
	public void onActivityCreated(Bundle savedInstanceState)
	{
		super.onActivityCreated(savedInstanceState);

		Resources resources = getResources();
		String[] names = resources.getStringArray(R.array.names);
		userListData.addAll(Arrays.asList(names));

		userListAdapter = new ArrayAdapter(getActivity(),
			android.R.layout.simple_list_item_multiple_choice,
			android.R.id.text1, userListData);
		setListAdapter(userListAdapter);

		ListView listView = getListView();
		listView.setChoiceMode(ListView.CHOICE_MODE_MULTIPLE_MODAL);
		listView.setMultiChoiceModeListener(new MultiChoiceDeleteModeListener());
	}

	private void deleteCheckedItems()
	{
		Log.v(LOG_TAG, "deleteCheckedItems() : Hello");

		ListView listView = getListView();
		long[] checkItemIds = listView.getCheckItemIds();
		Log.v(LOG_TAG, "deleteCheckedItems() : checkItemIds => " + checkItemIds);
		if (checkItemIds != null && checkItemIds.length > 0)
		{
			Log.v(LOG_TAG, "deleteCheckedItems() : checkItemIds.length => " + checkItemIds.length);
			for (int i = checkItemIds.length - 1; i >= 0; i--)
			{
				Log.v(LOG_TAG, "deleteCheckedItems() : delete at => " + checkItemIds[i]);
				userListData.remove((int) checkItemIds[i]);
			}
			userListAdapter.notifyDataSetChanged();
		}


		Log.v(LOG_TAG, "deleteCheckedItems() : Bye");
	}

	private class MultiChoiceDeleteModeListener implements MultiChoiceModeListener
	{

		public MultiChoiceDeleteModeListener()
		{
		}

		/**
		 * 各項目の選択状態が変わった際に呼ばれるコールバック。
		 *
		 * @param mode
		 * @param position
		 * @param id
		 * @param checked
		 */
		public void onItemCheckedStateChanged(ActionMode mode, int position, long id, boolean checked)
		{
			Log.v(LOG_TAG, "onItemCheckedStateChanged() : Hello");
			Log.v(LOG_TAG, "onItemCheckedStateChanged() : position => " + position);
			Log.v(LOG_TAG, "onItemCheckedStateChanged() : id => " + id);
			Log.v(LOG_TAG, "onItemCheckedStateChanged() : checked => " + checked);
			Log.v(LOG_TAG, "onItemCheckedStateChanged() : Bye");
		}

		public boolean onCreateActionMode(ActionMode mode, Menu menu)
		{
			Log.v(LOG_TAG, "onCreateActionMode() : Hello");

			MenuInflater menuInflater = getActivity().getMenuInflater();
			menuInflater.inflate(R.menu.delete_menu, menu);

			mode.setTitle(R.string.delete_users);
			mode.setSubtitle(R.string.delete_users);

			Log.v(LOG_TAG, "onCreateActionMode() : Bye");
			return true;
		}

		public boolean onPrepareActionMode(ActionMode mode, Menu menu)
		{
			Log.v(LOG_TAG, "onPrepareActionMode() : Hello");
			Log.v(LOG_TAG, "onPrepareActionMode() : Bye");
			return false;
		}

		public boolean onActionItemClicked(ActionMode mode, MenuItem item)
		{
			Log.v(LOG_TAG, "onActionItemClicked() : Hello");
			int itemId = item.getItemId();
			switch (itemId)
			{
				case R.id.delete_menuitem:
					Log.v(LOG_TAG, "onActionItemClicked() : delete_menuitem is clicked.");
					deleteCheckedItems();
					mode.finish();
					break;
			}
			Log.v(LOG_TAG, "onActionItemClicked() : Bye");
			return true;
		}

		/**
		 * アクションモード終了時のコールバック。
		 *
		 * ActionMode#finish() を呼び出したり、左上の「×」をクリックして アクションモードが終了したときに呼ばれる。
		 *
		 * @param mode
		 */
		public void onDestroyActionMode(ActionMode mode)
		{
			Log.v(LOG_TAG, "onDestroyActionMode() : Hello");
			Log.v(LOG_TAG, "onDestroyActionMode() : Bye");
		}
	}
}
