package com.example.hello.android.web_server_jetty_service_hello;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.text.Html;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends Activity implements OnClickListener,
	SharedPreferences.OnSharedPreferenceChangeListener
{

	private static final String LOG_TAG = "XXX";
	private ComponentName serviceComponentName;
	private SharedPreferences prefs;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		Button startServiceButton = (Button) findViewById(R.id.start_service_button);
		startServiceButton.setOnClickListener(this);

		Button stopServiceButton = (Button) findViewById(R.id.stop_service_button);
		stopServiceButton.setOnClickListener(this);

		TextView serverUriTextView = (TextView) findViewById(R.id.server_uri_textview);
		MovementMethod movementMethod = LinkMovementMethod.getInstance();
		serverUriTextView.setMovementMethod(movementMethod);

		prefs = getSharedPreferences(getPackageName(), MODE_PRIVATE);
		prefs.registerOnSharedPreferenceChangeListener(this);
	}

	@Override
	protected void onResume()
	{
		super.onResume();
		updateServerUri();
	}

	public void onClick(View view)
	{
		int id = view.getId();

		switch (id)
		{
			case R.id.start_service_button:
				startJettyService();
				break;
			case R.id.stop_service_button:
				stopJettyService();
				break;
		}
	}

	private void startJettyService()
	{
		Log.v(LOG_TAG, "startJettyService() : Hello");
		if (serviceComponentName == null)
		{
			Toast.makeText(getApplicationContext(), "Start Service!", Toast.LENGTH_SHORT).show();
			Intent intent = new Intent(this, JettyService.class);
			serviceComponentName = startService(intent);
		}
		Log.v(LOG_TAG, "startJettyService() : Bye");
	}

	private void stopJettyService()
	{
		if (serviceComponentName != null)
		{
			Toast.makeText(getApplicationContext(), "Stop Service!", Toast.LENGTH_SHORT).show();
			Intent intent = new Intent(this, JettyService.class);
			stopService(intent);
			serviceComponentName = null;
		}
	}

	public void onSharedPreferenceChanged(SharedPreferences prefs, String prefKey)
	{
		Log.v(LOG_TAG, "onSharedPreferenceChanged() : Hello");
		if ("server_uri".equals(prefKey))
		{
			updateServerUri();
		}
		Log.v(LOG_TAG, "onSharedPreferenceChanged() : Bye");
	}

	private void updateServerUri()
	{
		Log.v(LOG_TAG, "updateServerUri() : Hello");

		TextView serverUriTextView = (TextView) findViewById(R.id.server_uri_textview);
		String serverUriString = prefs.getString("server_uri", null);
		Log.d(LOG_TAG, "updateServerUri() : serverUriString => " + serverUriString);
		if (serverUriString != null)
		{
			Spanned fromHtml = Html.fromHtml("<a href=\"" + serverUriString + "\">" + serverUriString + "</a>");
			serverUriTextView.setText(fromHtml);
		}
		else
		{
			serverUriTextView.setText(R.string.not_working);
		}
		Log.v(LOG_TAG, "updateServerUri() : Bye");
	}
}
