package com.example.hello.android.viewflipper_with_flick;

/**
 * The MIT License
 *
 * Copyright 2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ViewFlipper;

public class MainActivity extends Activity implements OnClickListener, GestureDetector.OnGestureListener
{

	private static final String LOG_TAG = "XXX";
	private ViewFlipper viewFlipper;
	private Animation slideInLeftAnimation;
	private Animation slideInRightAnimation;
	private Animation slideOutLeftAnimation;
	private Animation slideOutRightAnimation;
	private GestureDetector gestureDetector;

	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);
		viewFlipper = (ViewFlipper) findViewById(R.id.viewflipper);

		slideInLeftAnimation = AnimationUtils.loadAnimation(this, R.anim.slide_in_left);
		slideInRightAnimation = AnimationUtils.loadAnimation(this, R.anim.slide_in_right);
		slideOutLeftAnimation = AnimationUtils.loadAnimation(this, R.anim.slide_out_left);
		slideOutRightAnimation = AnimationUtils.loadAnimation(this, R.anim.slide_out_right);

		gestureDetector = new GestureDetector(this, this);

		Button nextButton = (Button) findViewById(R.id.next_button);
		Button prevButton = (Button) findViewById(R.id.prev_button);
		nextButton.setOnClickListener(this);
		prevButton.setOnClickListener(this);
	}

	public void onClick(View v)
	{
		switch (v.getId())
		{
			case R.id.next_button:
				showNextPage();
				break;
			case R.id.prev_button:
				showPreviousPage();
				break;
		}
	}

	@Override
	public boolean dispatchTouchEvent(MotionEvent ev)
	{
		boolean result;

		result = gestureDetector.onTouchEvent(ev);
		if (result == false)
		{
			result = super.dispatchTouchEvent(ev);
		}

		return result;
	}

	private void showNextPage()
	{
		viewFlipper.setInAnimation(slideInRightAnimation);
		viewFlipper.setOutAnimation(slideOutLeftAnimation);
		viewFlipper.showNext();

	}

	private void showPreviousPage()
	{
		viewFlipper.setInAnimation(slideInLeftAnimation);
		viewFlipper.setOutAnimation(slideOutRightAnimation);
		viewFlipper.showPrevious();
	}

	public boolean onDown(MotionEvent me)
	{
		return false;
	}

	public void onShowPress(MotionEvent me)
	{
	}

	public boolean onSingleTapUp(MotionEvent me)
	{
		return false;
	}

	public boolean onScroll(MotionEvent me, MotionEvent me1, float f, float f1)
	{
		return false;
	}

	public void onLongPress(MotionEvent me)
	{
	}

	public boolean onFling(MotionEvent me1, MotionEvent me2, float vx, float vy)
	{
		boolean result = false;
		Log.v(LOG_TAG, "onFling() : Hello");
		Log.d(LOG_TAG, "onFling() : vx => " + vx);
		Log.d(LOG_TAG, "onFling() : vy => " + vy);
		float dx = Math.abs(me1.getX() - me2.getX());
		float dy = Math.abs(me1.getY() - me2.getY());
		if (dx > dy)
		{
			if (vx > 500)
			{
				showPreviousPage();
				result = true;
			}
			else if (vx < -500)
			{
				showNextPage();
				result = true;
			}
		}

		Log.v(LOG_TAG, "onFling() : Bye");
		return result;
	}
}
