/*
 * The MIT License
 *
 * Copyright 2013 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.view_custom_drawing_animation;

import android.content.Context;
import android.graphics.Canvas;
import android.util.Log;
import android.view.View;

public class LineArtView extends View
{

	private static final String LOG_TAG = "XXX";
	private LineArt lineArt;

	public LineArtView(Context context)
	{
		super(context);
		Log.d(LOG_TAG, "new CanvasView()");
	}

	@Override
	protected void onDraw(Canvas canvas)
	{
		super.onDraw(canvas);
//		Log.d(LOG_TAG, "onDraw()");
		lineArt.update();
		lineArt.draw(canvas);
	}

	public LineArt getLineArt()
	{
		return lineArt;
	}

	public void setLineArt(LineArt lineArt)
	{
		this.lineArt = lineArt;
	}
}
