/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package say.android.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Checkable;
import android.widget.LinearLayout;

/**
 *
 * @author sawai
 */
public class CheckableLinearLayout extends LinearLayout implements Checkable
{

	private static final String LOG_TAG = "XXX";
	private Checkable checkableView;

	public CheckableLinearLayout(Context context, AttributeSet attrs)
	{
		super(context, attrs);
	}

	public CheckableLinearLayout(Context context)
	{
		super(context);
	}

	public Checkable getCheckableView()
	{
		if (checkableView == null)
		{
			View view = this.findViewById(android.R.id.checkbox);
			if (view instanceof Checkable)
			{
				checkableView = (Checkable) view;
			}
			else
			{
				throw new IllegalStateException("No Checkable View");
			}
		}
		return checkableView;
	}

	public void toggle()
	{
		getCheckableView().toggle();
	}

	public void setChecked(boolean checked)
	{
		getCheckableView().setChecked(checked);
	}

	public boolean isChecked()
	{
		return getCheckableView().isChecked();
	}
}
