/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.ui_pattern_listview_crud_array;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;

public class UserDetailEditActivity extends Activity
	implements View.OnClickListener, UserConstants
{

	private static final String LOG_TAG = "XXX";

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "onCreate() : Hello");
		super.onCreate(savedInstanceState);
		setContentView(R.layout.user_detail_edit_activity);

		Intent intent = getIntent();

		// Bind view values
		UserDetailUtils.loadValuesFromIntent(this, intent);

		// Init listeners
		Button cancelButton = (Button) findViewById(R.id.cancel_button);
		Button saveButton = (Button) findViewById(R.id.save_button);
		cancelButton.setOnClickListener(this);
		saveButton.setOnClickListener(this);

		Log.v(LOG_TAG, "onCreate() : Bye");
	}

	public void onClick(View view)
	{
		Log.v(LOG_TAG, "onClick() : Hello");
		switch (view.getId())
		{
			case R.id.save_button:
				Log.d(LOG_TAG, "onClick() : saveButton is clicked.");
				saveAndFinish();
				break;
			case R.id.cancel_button:
				setResult(Activity.RESULT_CANCELED);
				finish();
				break;
		}
		Log.v(LOG_TAG, "onClick() : Bye");
	}

	private void saveAndFinish()
	{
		Intent resultIntent = new Intent();
		UserDetailUtils.saveValuesToIntent(this, resultIntent);
		setResult(Activity.RESULT_OK, resultIntent);
		finish();
	}
}
