/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.listview_simple_adapter_with_viewbinder;

import android.app.ListActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.SimpleAdapter;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class MainActivity extends ListActivity
	implements SimpleAdapter.ViewBinder
{

	private static final String LOG_TAG = "XXX";
	private static final String MAP_KEY_FIRST_NAME = "firstName";
	private static final String MAP_KEY_LAST_NAME = "lastName";
	private static final String MAP_KEY_SEX = "sex";
	private static final String MAP_KEY_EMAIL = "email";
	private static final String[] MAPPING_FROM = new String[]
	{
		MAP_KEY_FIRST_NAME, MAP_KEY_LAST_NAME, MAP_KEY_SEX, MAP_KEY_EMAIL
	};
	private static final int[] MAPPING_TO = new int[]
	{
		R.id.first_name_textview,
		R.id.last_name_textview,
		R.id.sex_textview,
		R.id.email_textview
	};
	private SimpleAdapter userListAdapter;
	private List<Map<String, String>> userList;
	private Random rand = new Random();

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);

		// Init ArrayAdapter
		userListAdapter = new SimpleAdapter(this, getUserList(),
			R.layout.user_list_item,
			MAPPING_FROM, MAPPING_TO);
		userListAdapter.setViewBinder(this);
		setListAdapter(userListAdapter);

		Button addButton = (Button) findViewById(R.id.add_button);
		addButton.setOnClickListener(new OnClickListener()
		{
			public void onClick(View view)
			{
				addNewUser();
			}
		});
	}

	public boolean setViewValue(View view, Object value, String textRepresentation)
	{
		Log.d(LOG_TAG, "setViewValue() Hello");
		Log.d(LOG_TAG, "setViewValue() view : " + view);
		Log.d(LOG_TAG, "setViewValue() value : " + value);
		Log.d(LOG_TAG, "setViewValue() text : " + textRepresentation);

		int viewId = view.getId();
		TextView textView = (TextView) view;
		if (viewId == R.id.sex_textview)
		{
			String sexText = textRepresentation;
			if ("0".equals(value))
			{
				sexText = "Male";
			}
			else if ("1".equals(value))
			{
				sexText = "Female";
			}
			textView.setText(sexText);
		}
		else
		{
			textView.setText(textRepresentation);
		}

		Log.d(LOG_TAG, "setViewValue() Bye");
		return true;
	}

	private List<Map<String, String>> getUserList()
	{
		if (userList == null)
		{
			userList = new ArrayList<Map<String, String>>();
			String[] names = getResources().getStringArray(R.array.names);
			for (String name : names)
			{
				HashMap<String, String> userInfo = new HashMap<String, String>();
				userInfo.put(MAP_KEY_FIRST_NAME, name);
				userInfo.put(MAP_KEY_LAST_NAME, "Smith");
				userInfo.put(MAP_KEY_SEX, String.valueOf(rand.nextInt(2))); // "0" or "1"
				userInfo.put(MAP_KEY_EMAIL, name.toLowerCase() + "@example.com");
				userList.add(userInfo);
			}
		}
		return userList;
	}

	private void addNewUser()
	{
		HashMap<String, String> newUserInfo = new HashMap<String, String>();
		newUserInfo.put(MAP_KEY_FIRST_NAME, "Test");
		newUserInfo.put(MAP_KEY_LAST_NAME, "Test");
		newUserInfo.put(MAP_KEY_SEX, String.valueOf(rand.nextInt(2)));
		newUserInfo.put(MAP_KEY_EMAIL, "test@example.com");
		userList.add(newUserInfo);
		userListAdapter.notifyDataSetChanged();
	}
}
