/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.layer_system_overlay;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.PixelFormat;
import android.os.IBinder;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;

/**
 *
 * @author sawai
 */
public class LayerViewService extends Service
{

	private static final String LOG_TAG = "XXX";
	private boolean running;
	private WindowManager windowManager;
	private View overlayView;

	@Override
	public void onCreate()
	{
		Log.v(LOG_TAG, "onCreate() : Hello");
		super.onCreate();
		windowManager = (WindowManager) getSystemService(Context.WINDOW_SERVICE);
		running = false;
		Log.v(LOG_TAG, "onCreate() : Bye");
	}

	@Override
	public void onStart(Intent intent, int startId)
	{
		Log.v(LOG_TAG, "onStart() : Hello");
		super.onStart(intent, startId);
		if (!running)
		{
			running = true;

			LayoutInflater inflater = LayoutInflater.from(this);
			overlayView = inflater.inflate(R.layout.hello_system_overlay, null);

			WindowManager.LayoutParams params = new WindowManager.LayoutParams(
				WindowManager.LayoutParams.WRAP_CONTENT,
				WindowManager.LayoutParams.WRAP_CONTENT,
				WindowManager.LayoutParams.TYPE_SYSTEM_OVERLAY,
				WindowManager.LayoutParams.FLAG_WATCH_OUTSIDE_TOUCH,
				PixelFormat.TRANSLUCENT);

			windowManager.addView(overlayView, params);
		}
		Log.v(LOG_TAG, "onStart() : Bye");
	}

	@Override
	public void onDestroy()
	{
		Log.v(LOG_TAG, "onDestroy() : Hello");
		if (running)
		{
			running = false;

			windowManager.removeView(overlayView);
		}
		super.onDestroy();
		Log.v(LOG_TAG, "onDestroy() : Bye");
	}

	@Override
	public IBinder onBind(Intent intent)
	{
		Log.v(LOG_TAG, "onBind() : Hello");
		Log.v(LOG_TAG, "onBind() : Bye");
		return null;
	}
}
