/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.intent_service_hello;

import android.app.IntentService;
import android.content.Intent;
import android.util.Log;

/**
 *
 * @author sawai
 */
public class CountDownService extends IntentService
{
	public static final String EXTRA_COUNT = "count";
	private static final long COUNT_INTERVAL_MSEC = 1000; // 1sec
	private static final int DEFAULT_COUNT = 10;
	private static final String LOG_TAG = "XXX";

	public CountDownService(String name)
	{
		super(name);
	}

	public CountDownService()
	{
		super(CountDownService.class.getName());
	}

	@Override
	public void onCreate()
	{
		Log.i(LOG_TAG, "CountDownService#onCreate() : Hello");
		super.onCreate();
		Log.i(LOG_TAG, "CountDownService#onCreate() : Bye");
	}

	@Override
	public void onDestroy()
	{
		Log.i(LOG_TAG, "CountDownService#onDestroy() : Hello");
		super.onDestroy();
		Log.i(LOG_TAG, "CountDownService#onDestroy() : Bye");
	}

	@Override
	public void onStart(Intent intent, int startId)
	{
		Log.i(LOG_TAG, "CountDownService#onStart() : Hello");
		super.onStart(intent, startId);
		Log.i(LOG_TAG, "CountDownService#onStart() : bye");
	}

	@Override
	protected void onHandleIntent(Intent intent)
	{
		Log.i(LOG_TAG, "CountDownService#onHandleIntent() : Hello");
		int count = intent.getIntExtra(EXTRA_COUNT, DEFAULT_COUNT);
		for (int i = count; i >= 0; i--)
		{
			Log.i(LOG_TAG, "CountDownService#onHandleIntent() count => " + i);
			try
			{
				Thread.sleep(COUNT_INTERVAL_MSEC);
			}
			catch (InterruptedException ex)
			{
				Log.e(LOG_TAG, "sleep failed.", ex);
			}
		}

		Log.i(LOG_TAG, "CountDownService#onHandleIntent() : Bye ");
	}
}
