package com.example.hello.android.dateformat_hello;

import android.app.Activity;
import android.os.Bundle;
import android.text.format.DateFormat;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import java.util.Date;

public class MainActivity extends Activity
{

	private static final String LOG_TAG = "XXX";

	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main_activity);

		updateFormattedText();
	}

	private void updateFormattedText()
	{
		Date now = new Date();
		java.text.DateFormat format;
		String formattedText;

		// DateFormat.getDateFormat()
		TextView dateFormatTextView = (TextView) findViewById(R.id.date_format_textview);
		format = DateFormat.getDateFormat(this);
		formattedText = format.format(now);
		dateFormatTextView.setText(formattedText);
		Log.d(LOG_TAG, "getDateFormat() : " + formattedText);

		// DateFormat.getMediumDateFormat()
		TextView mediumDateFormatTextView = (TextView) findViewById(R.id.medium_date_format_textview);
		format = DateFormat.getMediumDateFormat(this);
		formattedText = format.format(now);
		mediumDateFormatTextView.setText(formattedText);
		Log.d(LOG_TAG, "getMediumDateFormat() : " + formattedText);

		// DateFormat.getLongDateFormat()
		TextView longDateFormatTextView = (TextView) findViewById(R.id.long_date_format_textview);
		format = DateFormat.getLongDateFormat(this);
		formattedText = format.format(now);
		longDateFormatTextView.setText(formattedText);
		Log.d(LOG_TAG, "getLongDateFormat() : " + formattedText);

		// DateFormat.getTimeFormat()
		TextView timeFormatTextView = (TextView) findViewById(R.id.time_format_textview);
		format = DateFormat.getTimeFormat(this);
		formattedText = format.format(now);
		timeFormatTextView.setText(formattedText);
		Log.d(LOG_TAG, "getTimeFormat() : " + formattedText);
	}
}
