/*
 * The MIT License
 *
 * Copyright 2014 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.application_custom_hello;

import android.app.Application;
import android.content.res.Configuration;
import android.util.Log;
import android.widget.Toast;

/**
 *
 * @author Masahiko, SAWAI <masahiko.sawai@gmail.com>
 */
public class CustomApplication extends Application
{

	private static final String LOG_TAG = "XXX";

	@Override
	public void onCreate()
	{
		Log.v(LOG_TAG, "CustomApplication#onCreate() : Hello");
		Toast.makeText(this, "CustomApplication#onCreate()", Toast.LENGTH_SHORT).show();
		super.onCreate();
		Log.v(LOG_TAG, "CustomApplication#onCreate() : Bye");
	}

	@Override
	public void onTerminate()
	{
		Log.v(LOG_TAG, "CustomApplication#onTerminate() : Hello");
		super.onTerminate();
		Log.v(LOG_TAG, "CustomApplication#onTerminate() : Bye");
	}

	@Override
	public void onConfigurationChanged(Configuration newConfig)
	{
		Log.v(LOG_TAG, "CustomApplication#onConfigurationChanged() : Hello");
		super.onConfigurationChanged(newConfig);
		Log.v(LOG_TAG, "CustomApplication#onConfigurationChanged() : Bye");
	}

	@Override
	public void onLowMemory()
	{
		Log.v(LOG_TAG, "CustomApplication#onLowMemory() : Hello");
		super.onLowMemory();
		Log.v(LOG_TAG, "CustomApplication#onLowMemory() : Bye");
	}
}
