package com.example.hello.android.fragment_lifecycle;

import android.app.Activity;
import android.app.Fragment;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public class HelloFragment extends Fragment
{

	private static final String LOG_TAG = "HelloFragment";

	@Override
	public void onAttach(Activity activity)
	{
		Log.v(LOG_TAG, "onAttach() : Hello");
		super.onAttach(activity);
		Log.v(LOG_TAG, "onAttach() : Bye");
	}

	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "onCreate() : Hello");
		super.onCreate(savedInstanceState);
		Log.v(LOG_TAG, "onCreate() : Bye");
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "onCreateView() : Hello");
		View view = inflater.inflate(R.layout.hello_fragment, container, false);
		Log.v(LOG_TAG, "onCreateView() : Bye");
		return view;
	}

	@Override
	public void onActivityCreated(Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "onActivityCreated() : Hello");
		super.onActivityCreated(savedInstanceState);
		Log.v(LOG_TAG, "onActivityCreated() : Bye");
	}

	@Override
	public void onStart()
	{
		Log.v(LOG_TAG, "onStart() : Hello");
		super.onStart();
		Log.v(LOG_TAG, "onStart() : Bye");
	}

	@Override
	public void onResume()
	{
		Log.v(LOG_TAG, "onResume() : Hello");
		super.onResume();
		Log.v(LOG_TAG, "onResume() : Bye");
	}

	@Override
	public void onPause()
	{
		Log.v(LOG_TAG, "onPause() : Hello");
		super.onPause();
		Log.v(LOG_TAG, "onPause() : Bye");
	}

	@Override
	public void onStop()
	{
		Log.v(LOG_TAG, "onStop() : Hello");
		super.onStop();
		Log.v(LOG_TAG, "onStop() : Bye");
	}

	@Override
	public void onDestroyView()
	{
		Log.v(LOG_TAG, "onDestroyView() : Hello");
		super.onDestroyView();
		Log.v(LOG_TAG, "onDestroyView() : Bye");
	}

	@Override
	public void onDestroy()
	{
		Log.v(LOG_TAG, "onDestroy() : Hello");
		super.onDestroy();
		Log.v(LOG_TAG, "onDestroy() : Bye");
	}

	@Override
	public void onDetach()
	{
		Log.v(LOG_TAG, "onDetach() : Hello");
		super.onDetach();
		Log.v(LOG_TAG, "onDetach() : Bye");
	}
}
