/*
 *  The MIT License
 * 
 *  Copyright 2011-2012 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 * 
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 * 
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 * 
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package com.example.hello.android.appwidget_with_config_activity;

import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProvider;
import android.content.Context;
import android.util.Log;

/**
 *
 * @author sawai
 */
public class HelloAppWidgetProvider extends AppWidgetProvider
{

	private static final String LOG_TAG = "HelloAppWidgetProvider";

	@Override
	public void onEnabled(Context context)
	{
		Log.d(LOG_TAG, "onEnabled() : Hello");
		super.onEnabled(context);
		Log.d(LOG_TAG, "onEnabled() : Bye");
	}

	@Override
	public void onDisabled(Context context)
	{
		Log.d(LOG_TAG, "onDisabled() : Hello");
		super.onDisabled(context);
		Log.d(LOG_TAG, "onDisabled() : Bye");
	}

	@Override
	public void onUpdate(Context context, AppWidgetManager appWidgetManager, int[] appWidgetIds)
	{
		Log.d(LOG_TAG, "onUpdate() : Hello");
		super.onUpdate(context, appWidgetManager, appWidgetIds);
		for (int i = 0; i < appWidgetIds.length; i++)
		{
			Log.d(LOG_TAG, "onUpdate() : appWidgetIds[" + i + "] => " + appWidgetIds[i]);
		}
		Log.d(LOG_TAG, "onUpdate() : Bye");
	}

	@Override
	public void onDeleted(Context context, int[] appWidgetIds)
	{
		Log.d(LOG_TAG, "onDeleted() : Hello");
		super.onDeleted(context, appWidgetIds);
		for (int i = 0; i < appWidgetIds.length; i++)
		{
			Log.d(LOG_TAG, "onDeleted() : appWidgetIds[" + i + "] => " + appWidgetIds[i]);
		}
		Log.d(LOG_TAG, "onDeleted() : Bye");
	}
}
