/*
 * The MIT License
 *
 * Copyright 2012 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package com.example.hello.android.appwidget_listview;

import android.content.Intent;
import android.util.Log;
import android.widget.RemoteViews;
import android.widget.RemoteViewsService;

/**
 *
 * @author Masahiko, SAWAI <masahiko.sawai@gmail.com>
 */
public class ListViewAppWidgetRemoteViewsService extends RemoteViewsService
{

	private static final String LOG_TAG = "XXX";

	@Override
	public RemoteViewsFactory onGetViewFactory(Intent intent)
	{
		ListViewAppWidgetRemoteViewsFactory factory = new ListViewAppWidgetRemoteViewsFactory();
		return factory;
	}

	class ListViewAppWidgetRemoteViewsFactory implements RemoteViewsFactory
	{

		private String[] names;

		public void onCreate()
		{
			Log.v(LOG_TAG, "RemoteViewsFactory#onCreate() : Hello");
			names = getApplicationContext().getResources().getStringArray(R.array.names);
			Log.v(LOG_TAG, "RemoteViewsFactory#onCreate() : Bye");
		}

		public void onDataSetChanged()
		{
			Log.v(LOG_TAG, "RemoteViewsFactory#onDataSetChanged() : Hello");
			Log.v(LOG_TAG, "RemoteViewsFactory#onDataSetChanged() : Bye");
		}

		public void onDestroy()
		{
			Log.v(LOG_TAG, "RemoteViewsFactory#onDestroy() : Hello");
			Log.v(LOG_TAG, "RemoteViewsFactory#onDestroy() : Bye");
		}

		public int getCount()
		{
			int count = 0;
			Log.v(LOG_TAG, "RemoteViewsFactory#getCount() : Hello");

			if (names != null)
			{
				count = names.length;
			}
			Log.d(LOG_TAG, "RemoteViewsFactory#getCount() : count => " + count);

			Log.v(LOG_TAG, "RemoteViewsFactory#getCount() : Bye");
			return count;
		}

		public RemoteViews getViewAt(int position)
		{
			Log.v(LOG_TAG, "RemoteViewsFactory#getViewAt() : Hello");
			Log.d(LOG_TAG, "RemoteViewsFactory#getViewAt() : position => " + position);

			RemoteViews remoteViews = new RemoteViews(getApplicationContext().getPackageName(),
				R.layout.listview_item);

			remoteViews.setTextViewText(R.id.name_textview, names[position]);

			// remoteViews がクリックされた際に発行されるインテントは
			// setPendingIntentTemplate() で設定したインテントに以下のインテントの
			// 情報を追加( Intent#fillIn() )したものとなる
			Intent fillInIntent = new Intent();
			fillInIntent.putExtra(HelloActivity.EXTRA_NAME, names[position]);
			remoteViews.setOnClickFillInIntent(R.id.name_textview, fillInIntent);

			Log.v(LOG_TAG, "RemoteViewsFactory#getViewAt() : Bye");
			return remoteViews;
		}

		public RemoteViews getLoadingView()
		{
			Log.v(LOG_TAG, "RemoteViewsFactory#getLoadingView() : Hello");
			Log.v(LOG_TAG, "RemoteViewsFactory#getLoadingView() : Bye");
			return null;
		}

		public int getViewTypeCount()
		{
			Log.v(LOG_TAG, "RemoteViewsFactory#getViewTypeCount() : Hello");
			Log.v(LOG_TAG, "RemoteViewsFactory#getViewTypeCount() : Bye");
			return 1;
		}

		public long getItemId(int position)
		{
			Log.v(LOG_TAG, "RemoteViewsFactory#getItemId() : Hello");
			Log.d(LOG_TAG, "RemoteViewsFactory#getItemId() : position => " + position);
			Log.v(LOG_TAG, "RemoteViewsFactory#getItemId() : Bye");
			return position;
		}

		public boolean hasStableIds()
		{
			Log.v(LOG_TAG, "RemoteViewsFactory#hasStableIds() : Hello");
			Log.v(LOG_TAG, "RemoteViewsFactory#hasStableIds() : Bye");
			return true;
		}
	}
}
