/*
 *  The MIT License
 * 
 *  Copyright 2011-2012 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 * 
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 * 
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 * 
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package com.example.hello.android.appwidget_on_click;

import android.app.PendingIntent;
import android.appwidget.AppWidgetManager;
import android.appwidget.AppWidgetProvider;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.widget.RemoteViews;

/**
 *
 * @author sawai
 */
public class ClickableAppWidgetProvider extends AppWidgetProvider
{

	private static final String LOG_TAG = "HelloAppWidgetProvider";

	public ClickableAppWidgetProvider()
	{
		Log.d(LOG_TAG, "ClickableAppWidgetProvider() : Hello");
	}

	@Override
	public void onEnabled(Context context)
	{
		Log.d(LOG_TAG, "onEnabled() : Hello");
		Log.d(LOG_TAG, "onEnabled() : Bye");
	}

	@Override
	public void onDisabled(Context context)
	{
		Log.d(LOG_TAG, "onDisabled() : Hello");
		Log.d(LOG_TAG, "onDisabled() : Bye");
	}

	@Override
	public void onUpdate(Context context, AppWidgetManager appWidgetManager, int[] appWidgetIds)
	{
		Log.d(LOG_TAG, "onUpdate() : Hello");

		for (int appWidgetId : appWidgetIds)
		{
			// Init Intent
			Intent intent = new Intent(context, HelloActivity.class);
			PendingIntent pi = PendingIntent.getActivity(context, 0, intent, 0);

			// Set on click handler
			RemoteViews remoteViews = new RemoteViews(context.getPackageName(), R.layout.clickable_appwidget);
			remoteViews.setOnClickPendingIntent(R.id.appwidget_container, pi);

			// Update AppWidget
			appWidgetManager.updateAppWidget(appWidgetId, remoteViews);
		}

		Log.d(LOG_TAG, "onUpdate() : Bye");
	}

	@Override
	public void onDeleted(Context context, int[] appWidgetIds)
	{
		Log.d(LOG_TAG, "onDeleted() : Hello");

		for (int i = 0; i < appWidgetIds.length; i++)
		{
			Log.d(LOG_TAG, "onDeleted() : appWidgetIds[" + i + "] => " + appWidgetIds[i]);
		}

		Log.d(LOG_TAG, "onDeleted() : Bye");
	}
}
