/*
 *  The MIT License
 *
 *  Copyright 2011-2012 Masahiko, SAWAI <masahiko.sawai@gmail.com>.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.notepad.prefs;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.ListPreference;
import android.preference.PreferenceActivity;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import org.routine_work.notepad.NotepadActivity;
import org.routine_work.notepad.R;
import org.routine_work.utils.Log;

/**
 *
 * @author sawai
 */
public class NotepadPreferenceActivity extends PreferenceActivity
	implements SharedPreferences.OnSharedPreferenceChangeListener
{

	private static final String LOG_TAG = "android.R";
	private SharedPreferences sharedPreferences;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		Log.v(LOG_TAG, "Hello");

		setTheme(NotepadPreferenceUtils.getTheme(this));
		super.onCreate(savedInstanceState);
		addPreferencesFromResource(R.xml.notepad_preference);
		sharedPreferences = getPreferenceManager().getSharedPreferences();

		Log.v(LOG_TAG, "Bye");
	}

	@Override
	protected void onResume()
	{
		Log.v(LOG_TAG, "Hello");
		super.onResume();

		sharedPreferences.registerOnSharedPreferenceChangeListener(this);
		updateSummary();
		Log.v(LOG_TAG, "Bye");
	}

	@Override
	protected void onPause()
	{
		Log.v(LOG_TAG, "Hello");
		sharedPreferences.unregisterOnSharedPreferenceChangeListener(this);

		super.onPause();
		Log.v(LOG_TAG, "Bye");
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		MenuInflater menuInflater = getMenuInflater();
		menuInflater.inflate(R.menu.quit_option_menu, menu);

		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		boolean result = true;

		int itemId = item.getItemId();
		switch (itemId)
		{
			case R.id.quit_menuitem:
				NotepadActivity.quitApplication(this);
				break;
			default:
				result = super.onOptionsItemSelected(item);
		}

		return result;
	}

	public void onSharedPreferenceChanged(SharedPreferences prefs, String key)
	{
		Log.v(LOG_TAG, "Hello");
		Log.i(LOG_TAG, "shared preference " + key + " is changed.");

		updateSummary();

		Log.v(LOG_TAG, "Bye");
	}

	private void updateSummary()
	{
		Log.v(LOG_TAG, "Hello");
		CharSequence summary;

		// Theme
		final String notepadThemeKey = getString(R.string.notepad_theme_key);
		final String notepadThemeDefaultValue = getString(R.string.notepad_theme_default_value);
		ListPreference notepadThemeListPreference = (ListPreference) getPreferenceScreen().findPreference(notepadThemeKey);
		summary = notepadThemeListPreference.getEntry();
		notepadThemeListPreference.setSummary(summary);

		// Layout
		final String noteListLayoutPortKey = getString(R.string.note_list_layout_port_key);
		final String noteListLayoutLandKey = getString(R.string.note_list_layout_land_key);
		final String noteListLayoutPortDefaultValue = getString(R.string.note_list_layout_port_default_value);
		final String noteListLayoutLandDefaultValue = getString(R.string.note_list_layout_land_default_value);

		String noteListLayoutPortValue = sharedPreferences.getString(noteListLayoutPortKey, noteListLayoutPortDefaultValue);
		summary = getLayoutName(noteListLayoutPortValue);
		ListPreference noteListLayoutPortPreference = (ListPreference) getPreferenceScreen().findPreference(noteListLayoutPortKey);
		noteListLayoutPortPreference.setSummary(summary);

		String noteListLayoutLandValue = sharedPreferences.getString(noteListLayoutLandKey, noteListLayoutLandDefaultValue);
		summary = getLayoutName(noteListLayoutLandValue);
		ListPreference noteListLayoutLandPreference = (ListPreference) getPreferenceScreen().findPreference(noteListLayoutLandKey);
		noteListLayoutLandPreference.setSummary(summary);

		Log.v(LOG_TAG, "Bye");
	}

	private String getLayoutName(String layoutValue)
	{
		final String noteListLayoutSingle = getString(R.string.note_list_layout_single_value);
		final String noteListLayoutWideTwo = getString(R.string.note_list_layout_wide_two_value);
		String name = null;

		if (noteListLayoutSingle.equals(layoutValue))
		{
			name = getString(R.string.single_pane);
		}
		else if (noteListLayoutWideTwo.equals(layoutValue))
		{
			name = getString(R.string.wide_two_pane);
		}

		return name;
	}
}
