// -*- C++ -*-
/*!
 * @file  Routing.h
 * @brief Network routing information handling functions
 * @date  $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2010
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#ifndef COIL_ROUTING_H
#define COIL_ROUTING_H

#include <string>
 
namespace coil
{
  /*!
   * @if jp
   * @brief AhX痘pGh|CgAhX𓾂
   * 
   * AhX^ƁA̍ۂɗpGh|Cg̃AhX
   * ԂBAhX dest_addr ɂ́AIPAhX܂FQDNzX
   * g^邱ƂłBAhX
   * B\łApGh|Cgꂽꍇ trueAAh
   * XɓBłȂꍇ false ԂB
   *
   * @param dest_addr AhX܂̓zXg
   * @param dest_if ƒʐMsۂɎgpC^[tF[X
   * @return  true, s false
   * 
   * @else
   * @brief Getting network interface name from destination address
   *
   * This operation returns IP address of a endpoint to be used to
   * communicate with the given destination address. IP address and
   * FQDN hostname are available for the destination address
   * dest_addr. If a destination address are reachable and an endpoint
   * IP address is available, this operation returns true, and
   * otherwise false.
   *
   * @param dest_addr a destination address or host name
   * @param endpoint a IP address of the endpoint to be used to communicate
   *                 with the destination address
   * @return successful: true, failed: false
   *
   * @endif
   */
  bool dest_to_endpoint(std::string dest_addr, std::string& endpoint);

}; //namespace coil
#endif // COIL_ROUTING_H
