// -*- C++ -*-
/*!
 * @file Task.cpp
 * @brief Task class
 * @date $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2008
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#ifndef COIL_OS_H
#define COIL_OS_H

#include <string>
#ifdef __T_KERNEL__
#include "nes_posix_signal.h"

#else
#include <sys/utsname.h>
#include <sys/types.h> 
#include <unistd.h> 
#endif
#include <stdlib.h>

extern "C"
{
  extern char *optarg;
};

namespace coil
{
#ifdef __T_KERNEL__
  #define _UTSNAME_SYS_NMLN 64
  struct tk_utsname
  {
    char sysname[_UTSNAME_SYS_NMLN];
    char nodename[_UTSNAME_SYS_NMLN];
    char release[_UTSNAME_SYS_NMLN];
    char version[_UTSNAME_SYS_NMLN];
    char machine[_UTSNAME_SYS_NMLN];
  };
  typedef tk_utsname utsname;
#else
  typedef ::utsname utsname;
#endif
  inline int uname(utsname* name)
  {
#ifdef __T_KERNEL__
#ifdef DEBUG_T_KERNEL
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
    strcpy (name->sysname, "PMC/Extention");
    strcpy (name->release, "unknow");
    strcpy (name->version, "unknow");
    strcpy (name->machine, "unknow");
    return 0;
#else
    return ::uname(name);
#endif
  }

#ifndef __T_KERNEL__
  typedef ::pid_t pid_t;
#endif
  inline pid_t getpid()
  {
#ifdef __T_KERNEL__
#ifdef DEBUG_T_KERNEL
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
    return nes_posix_getpid();
#else
    return ::getpid();
#endif
  }

#ifndef __T_KERNEL__
  inline pid_t getppid()
  {
    return ::getppid();
  }
#endif

  inline char* getenv(const char *name)
  {
    return ::getenv(name);
  }

#ifdef __T_KERNEL__
  class GetOpt
  {
  public:
    GetOpt(int argc, char* const argv[], const char* opt, int flag)
     : m_argc(argc), m_argv(argv), m_opt(opt), m_flag(flag)
    {
#ifdef DEBUG_T_KERNEL
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
      optnum = 1;
      lastopt = 0;
#ifdef DEBUG_T_KERNEL
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
    }

    ~GetOpt()
    {
    }

    int operator()()
    {
#ifdef DEBUG_T_KERNEL
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
       int opt = 0;
       optarg =0;
       
       if(m_argv == 0)
       {
         optnum = 0;
#ifdef DEBUG_T_KERNEL
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
         return -1;
       }
       
       while( opt == 0 )
       {
         if(optnum >= m_argc)
         {
#ifdef DEBUG_T_KERNEL
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
           return -1;
         }
         
         if(m_argv[optnum][0] == '-' && m_argv[optnum][1] != '\0')
         {
           int i = 0;
           if(lastopt != 0)
           {
             while(lastopt != m_argv[optnum][i]) i++ ;
           }
           
           opt = m_argv[optnum][i+1];
           if(m_argv[optnum][i+2] == '\0')
           {
             lastopt = 0;
           }else{
             lastopt = opt;
           }
           
           char* tmp = strchr(m_opt, opt);
           if(tmp == NULL)
           {
             opt = 0;
           }else{
             if(*(tmp+1) == ':')
             {
               optarg = m_argv[optnum + 1];
             }
           }
         }else{
           optnum++;
         }
       }
       if(lastopt == 0) optnum++;
#ifdef DEBUG_T_KERNEL
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
       return opt ;
    }

    char* optarg;  // ץ
    int   lastopt;
    int   optnum;

  private:
    int m_argc;
    char* const * m_argv;
    const char* m_opt;
    int m_flag;

  };
#else
  /* Global Variables for getopt() */
  class GetOpt
  {
  public:
    GetOpt(int argc, char* const argv[], const char* opt, int flag)
      : optarg(::optarg), optind(1), opterr(1), optopt(0), m_argc(argc), m_argv(argv), m_opt(opt), m_flag(flag)
    {
      ::optind = 1;
    }

    ~GetOpt()
    {
      ::optind = 1;
    }

    int operator()()
    {
      ::opterr = opterr;
      ::optind = optind;

      int result = getopt(m_argc, m_argv, m_opt);

      optarg = ::optarg;
      optind = ::optind;
      optopt = ::optopt;

      return result;
    }
    char* optarg;     //! ץ
    int optind;       //! оݰ
    int opterr;       //! 顼ɽ 0:޻ߡ1:ɽ
    int optopt;       //! ץʸ­ʤ¿˥åȤ

  private:
    int m_argc;
    char* const * m_argv;
    const char* m_opt;
    int m_flag;
  };
#endif
};

#endif // COIL_OS_H
