
                HOW TO COPYRIGHT SOFTWARE (Yourself)
                ------------------------------------
                       (c) 1993 Locus Inc.

         * *  Updated for Changes to Copyright Act  * *

PREFACE TO THE DISK VERSION

     This booklet is a programmer's guide to copyrighting software
in the United States.  It contains step-by-step instructions from
a programmer/attorney how to complete the official application for
a Certificate of Copyright Registration.  This material is being
distributed on the honor system.  It is not public domain or free,
although it may be uploaded or downloaded freely.  Just like a book
in a bookstore, you have a limited right to look before you buy. 
If you send $14.95 to the address below, includes S&H, you will
receive a printed copy of the entire work, including the official
application form and examples that could not be uploaded because
they contain non-ASCII graphics. 
                            
                   Thank you for your support!
                            *  *  *
   	            Locus Inc., 122 Peace Lane,
                   Pewee Valley, KY  40056-9001 
                Internet: 72426.2567@COMPUSERVE.COM

 +------------------------------------------------------+
 | ORDER FORM 93:  HOW TO COPYRIGHT SOFTWARE (YOURSELF) |
 |                                                      |
 | NAME:_______________________________________________ |
 |                                                      |
 | ADDRESS:____________________________________________ |
 |                                                      |
 | CITY/STATE/ZIP:_____________________________________ |
 |                                                      |
 |------------------------------------------------------|
 | Send $14.95 to:                   |                  |
 |   Locus Inc., 122 Peace Lane      |   Thank You!     | 
 |   Pewee Valley, KY  40056-9001    |                  |
 +------------------------------------------------------+ 

NOTE:  The disk version of this booklet is a standard ASCII text
file with hard carriage returns at the ends of the lines.  This
file contains no special control characters or printer codes, so
should print fine with the DOS PRINT command, or convert cleanly
into most word processors. 

================================================================ 

                HOW TO COPYRIGHT SOFTWARE (Yourself)
                ------------------------------------
                       (c) 1993 Locus Inc

INTRODUCTION

     Everyone knows how easily computer programs and manuals can be
copied.  Registration with the United States Copyright Office in
Washington D.C. is an excellent way to protect your valuable work
product with a minimum of red tape and expense.  Computer software
may also be protected by patents and trademarks.  Copyrights stop
copying.  Patents stop making, using or selling.  Trademarks stop
confusing names.  Unfortunately, procedures in the U.S. Patent and
Trademark Office are considerably more complex, time consuming and
expensive than in the Copyright Office, thus they are not covered
in this brief guide. 

     Because all software protection schemes require some degree of
familiarity with copyright law, Chapter 1 briefly discusses the
basics of copyrights, with an emphasis on software.  Chapter 2
takes a more nuts-and-bolts approach as to how to actually fill out
the deceptively simple application form "TX."  Chapter 3 then deals
with the final details of where, when, and what to send to the
Copyright Office along with your application.  Lastly, the Appendix
contains all the forms, letters and examples you will need to
complete and file your application. 
                        
                           * * * * *
 TABLE OF CONTENTS

Preface
Introduction

Chapter 1  Computer Law Basics
  1.1        Ideas are Free
  1.2        Scope of Protection
  1.3        Bundle of Rights
  1.4        Infringements
  1.5        Copyright Notice

Chapter 2  Application Form TX
  2.1        Space 1 - Title
  2.2        Space 2 - Authorship
  2.2.1        Name of Author
  2.2.2        Works Made For Hire
  2.2.3        Nationality
  2.2.4        Anonymity
  2.2.5        Nature of Authorship
  2.3        Space 3 - Dates
  2.3.1        Creation
  2.3.2        Publication
  2.4        Space 4 - Claimant
  2.4.1        Claimant is Author
  2.4.2        Claimant is not Author
  2.4.3        Claimant is Joint Author
  2.4.4        Transfer Statement
  2.5        Space 5 - Previous Registration
  2.6        Space 6 - Derivative Works or Compilations
  2.6.1        Preexisting Material
  2.6.2        Material Added
  2.6.3        Examples
  2.7        Space 7 - (deleted)
  2.8        Space 8 - Reproduction for Blind or Handicapped   
  2.9        Space 9 - Correspondence From Office
  2.10       Space 10 - Signature and Certification
  2.11       Space 11 - Return Address For Certificate

Chapter 3  Final Steps 
  3.1        Filing Fee
  3.2        Deposit Requirements
  3.2.1        Special Relief and Trade Secrets
  3.2.2        Object Code and Rule of Doubt
  3.2.3        Screen Displays
  3.3        Mailing
  3.4        Office Action 
  3.5        About the Author

Appendix
Index
CHAPTER 1:  COMPUTER LAW BASICS 

     This booklet is designed to be a practical guide for non-
lawyers.  A  conscious effort was made to cut out legalese and
lawyer talk.  However, copyrights are deceptively simple.  The
basic concepts can be stated in a few sentences, yet the law
construing them occupies volumes.  By all means, consult with your
lawyer if you have questions about any part of this registration
process.  Or feel free to call the support BBS listed above.  Two
other good sources of online legal information are GEnie's Legacy
and Compuserve's LawSig.


1.1  IDEAS ARE FREE

      Copyright does not protect ideas, only expressions of ideas. 
What does that mean?  Think about it.  An idea is an original
thought in your brain.  An expression is that same thought reduced
to something you can see or hear.  Particularly with software, if
you can see it you probably have an expression.  For example, you
can see source code, but not mental logic.  Therefore, source code
is protected, logic is not.  Thus, the first rule for any copyright
is there must be a tangible form of
expression.
 
     The second rule is that the expression must be original. 
However, a single idea can be expressed more than one way.  For
example,  Lotus 1-2-3 and Microsoft Excel both share the same idea
of an electronic spreadsheet, yet each expresses the idea
differently.  They have different interfaces, file structures, and
source code.  There is no infringement.  So, copyright only
protects original expressions that are fixed in some tangible
format. 

     Sometimes an idea is so common or there are so few ways to
express it that the idea and the expression are said to merge.  A
merger of the idea and its expression occurs when the expression is
indispensable to the treatment of the idea.  As a result, the scope
of protection may be severely limited if you end up in court.


1.2  SCOPE OF PROTECTION

     Copyright protection is readily available for computer
programs in all their forms, including source code, object code,
and microcode.  You can also copyright written documentation and
user manuals on the same application made for software.  However,
copyright protection does NOT extend to the underlying procedure,
process, system, method, concept, principle, discovery, formula or
algorithm, regardless of the format in which it is coded,
described, illustrated or embodied in the work. 

     A derivative work is one based upon or incorporating a
preexisting work.  For example, MicroSoft Windows 3.0 derives from
Windows 2.0, thus 3.0 is a derivative work of 2.0, and so on. 
Other examples of derivative works include translations (ex.
rewriting BASIC into C), abridgements (ex. releasing a Lite
version), and additions (ex. adding pulldown menus).  So whenever
a work is recast, transformed, or adapted, and the changes are
significant enough, you have a derivative work.
 
     A compilation occurs when you collect and assemble other
preexisting materials or data.  The creative effort in a
compilation copyright is in how you select, coordinate, or arrange
the material.  The classic example of a compilation copyright is
the telephone directory.  Another example would be a sampler disk
or a collection of programs from various authors (ex. PC Magazine
Utilities Disk).  Note that you must have a copyright owner's
permission before reproducing, including or changing his work.

     Public domain materials do not belong to anyone.  They may be
copyrights that have expired or the author has dedicated to the
public.  Or perhaps the author never registered the work, or maybe
the registration was denied for lack of proper subject matter. 
Whatever the reason, public domain material does not have an owner,
per se, and may be copied or included in derivative works and
compilations.


1.3  BUNDLE OF RIGHTS  

     A copyright owner has certain exclusive rights.  Only the
owner of a copyright on a program can:  (1) reproduce or authorize
copying of the program;  (2) make derivative works or changes to
the program;  and (3) distribute, license or sell the program. 
These exclusive rights last for the life of the author, plus 50
years.  Or if the  work was made for hire (see Section 2.2.2), for
75 years from the date of publication, or 100 years from creation,
whichever is shorter.

     Having a Certificate of Registration is prima facie evidence
of the validity of your copyright.  Also, if you are registered at
the time of the infringement, the defendant can no longer claim to
be an "innocent infringer."  Plus, you can recover your attorney
fees if you have to go to court to enforce your rights (and win). 

     When courts must determine who has right, title and interest
in a program, judges often struggle with the idea-expression
dichotomy.  However, modern courts have recognized that software
consists of four legally significant elements:  (1) source and
object code;  (2) structure, sequence and organization;  (3)
function or purpose; and  (4) user interface.  Copyright treats
each element as an independent work of authorship provided it
qualifies as an expression rather than an idea. 

1.4  INFRINGEMENTS  

     Suppose you discover someone is making unauthorized copies or
your software or is marketing a blatant ripoff or a former employee
is incorporating code he wrote for you in another program.  How can
you stop them?  You must first have a Certificate of Registration. 
You cannot file suit until you are registered.  Then, a federal
judge can issue an injunction ordering the defendant to cease and
desist the infringing activities.  The judge can even direct a U.S.
Marshall (remember Marshall Dillon on "Gunsmoke?") to seize and
destroy the infringing materials.  Later at trial, you may be
awarded money damages based on, say, your lost business or the
defendant's unjust profits.  Or if your damages are unknown, you
can opt for statutory damages of up to $100,000 per infringement,
provided you were registered at the time of the infringement.
    
     If you were not registered when you learned of the infringer,
all is not lost, but must file right away if you plan to litigate. 
The Copyright Office can provide expedited handling upon special
request.  The "Request for Special Handling" in the Appendix
requires a sworn statement explaining the urgency, accompanied by
a special processing fee of $200.00.  If your request is granted,
the Office will attempt to process the application within 5 days.

     To constitute an infringement, two works must be substantially
similar.  Obviously, this is a subjective standard.  Modern courts
may use a two-part test to determine whether one programs infringes
another.  First, a skilled programmer may scrutinize the code and
say whether the sequence, structure and organization of the two
have a comprehensive nonliteral similarity.  Second, the judge or
jury may simply observe the two programs running side-by-side and
say whether they have the same overall "look and feel."  If both
tests are true, there is infringement.  If only one test is true,
other factors may be considered.

1.5  COPYRIGHT NOTICE
 
     The copyright notice is not required.  The law before 1989 was
that if you failed to use a valid copyright notice, you could lose
your copyrights in the work.  That is no longer the case.  But, I 
STRONGLY RECOMMEND that you use the copyright notice by putting the 
following notice prominently on your startup screens, in your source 
code, on user manuals and all other documentation, including disks: 

   **********************************************************
   *  COPYRIGHT (C) 1993 ABC COMPANY.  ALL RIGHTS RESERVED. *
   **********************************************************

    Note the three parts to the copyright notice: (1) COPYRIGHT or
COPR or (C);  (2) the YEAR of creation or first publication;  and
(3) the NAME of the copyright owner.  ALL RIGHTS RESERVED is not
required, but gives you rights in other parts of the world.  

CHAPTER 2:  APPLICATION FORM TX

     A Certificate of Copyright Registration is to software like a
Deed is to land.  Both are proof of ownership and title.  However,
your copyrights exist the instant you write the code without having
to do anything.  But to perfect your rights, you should register
your work with the U.S. Copyright Office.  This process can be done
without lawyers and usually takes about three to six months.
 
       The Copyright Office considers software to be a "writing,"
like a book or a poem, therefore the same application form is used
as for texts.  In fact, the TX is short for TeXt.  The following
are all that are required to apply for a copyright:

          (1)  A completed Form TX.  
          (2)  One copy of the program.  
          (3)  The filing fee ($20).

      A blank TX Form and several other forms and samples are found
in the Appendix.  You can make and use copies of these forms, but
be sure the two-sided TX form is copied onto two-sided paper if you
intend to file it.  The Appendix also has an example of what a
Certificate of Copyright Registration looks like.  

      The Copyright Office has a "single registration" policy, that
is, they prefer only one application per work.  However, since
since software is rarely one giant program, but is usually a system
of modules, including screens, overlays, drivers, help files,
config files, documentation, manuals, etc., the question arises
whether one registration can cover the whole thing?  The answer is
YES.  The Copyright Office considers all these parts to be a single
work and insists that they be handled on a single application. 

     The TX form is only two pages, with only 11 numbered spaces
for supplying information.  Each space has multiple lines, sub-
parts,  or boxes to check.  Throughout this Chapter, my Section
numbering scheme follows the corresponding space on the Form TX . 
Examples are in ALL CAPITAL LETTERS or within "quotation marks."  

2.1  SPACE 1 - TITLE

     The name or title of your program goes in Space 1, Line 1. 
This should be the full, popular title of your program, including
version number (if any).  For example: "MICROSOFT QUICKBASIC 4.5"
or "LOTUS 1-2-3, RELEASE 3.0."  There is no copyright in titles, so
the program name does not have to be completely original.  Just be
sure not to use someone else's trade name or trademark without
their permission.

     Usually, you can skip the rest of Space 1.  However, if your
program has another name, give that name in Line 2 of Space 1.  Or
if your program is part of a collection (such as a sampler disk or
magazine), give the title of the magazine or sampler in Line 3, and
state the volume and issue number in Line 4.  For example, "BYTE
MAGAZINE, JANUARY 1991."


2.2  SPACE 2 - AUTHORSHIP

    This is the most important section.  Your answers here must be
consistent with your answers in Space 4 (Claimant).  Correctly
identifying authorship involves significant rights and will have a
major impact on ultimate ownership, use, and transfer of the
software.  Be sure to read through all of Section 2.2 first.

2.2.1  NAME OF AUTHOR

  FOR INDIVIDUALS ==>  If you wrote the program, put your full name
and birthdate in Line 1 of Space 2(a).  If you wrote the software
jointly with one or more people with the intention that all
contributions be merged into a whole, give each person's full name
and birthdate in Spaces 2(b), 2(c), etc. If additional spaces are
needed, use Form TX/CON in Appendix A. 

  FOR BUSINESSES ==>  If you are operating as a business and the
programming was done by you or regular employees of your business,
then put your company's full legal name as the author in Space
2(a), Line 1.  Leave the birthdate information blank.  Please be
sure to read Section 2.2.2 very closely, especially if you had any
contract programming done.  

 2.2.2  WORK MADE-FOR-HIRE.  On the left side of Line 2, Space 2,
there is a check box for a tricky question:  "Was this contribution
to the work a 'work made for hire'?"  This is a legal term of art. 
A work is made-for-hire if it is (1) prepared by employees within
the scope of their employment;  or (2) specially ordered or
commissioned and the parties agree IN WRITING that the work is
made-for-hire.  The author of a work made-for-hire is generally the
employer, not the employee.  Just because you paid for it doesn't
mean it yours.

     Work-for-hire situations can arise several ways.  For example,
a dentist hires a neighbor's kid to write a billing system, or a
bank hires temporary contract programmers to finish a big project. 
Even if the programmer is given instructions every step of the way,
there must be a written agreement signed by both parties
acknowledging the work is made-for-hire.  Otherwise, all or part of
the copyright belongs to the programmer. 
 
      Therefore, if any part of the program was made-for-hire, you
must check "YES" in the box provided on Line 2 of Space 2, give the
employer's name as the Author of that part of the work.  Leave the
space for dates of birth and death blank. 

2.2.3  NATIONALITY.  In the middle of Line 2 of Space 2, you must
give the country where the author is a citizen or is domiciled.  In
most cases, the author of the work will be a U.S. citizen or
business.  In general, a person is domiciled in the place where he
or she has a fixed and permanent residence with an intention to
continue living at that residence for an unlimited time or to
return to it whenever absent.  If the author is a foreign company,
give the country where the business is domiciled.  
 
2.2.4  ANONYMITY.  On the right of Space 2, Line 2, you can
register anonymously.  Anonymous registration is NOT recommended.
You should just check "NO" to both questions here.  Always check
with your attorney before checking Anonymous or Pseudonymous.  But
if you insist on being Anonymous, you can put "ANONYMOUS" for the
Name of Author in Line 1, or just leave blanks for the Name. If you
insist, you can give a pseudonym for the Name of Author, provided
you qualify it with the word "PSEUDONYM" (ex. "BIG JOHN,
PSEUDONYM"), or you can give your real name plus your pseudonym
(ex. "WILLIAM GATES, WHOSE PSEUDONYM IS WILD BILL").  

2.2.5  NATURE OF AUTHORSHIP.  In Space 2, Line 3, the Copyright
Office wants a VERY BRIEF description of your work.  Brief Means
Terse!  Just put "COMPUTER PROGRAM."  If you also want to register
the documentation, just put "COMPUTER PROGRAM AND DOCUMENTATION." 
Get the picture?  Do not give any more detail than absolutely
necessary.  Particularly avoid descriptions of program functions,
screens, design, structure, and the like.  The more detailed you
get, the more likely the Copyright Office will question your
application. 


2.3  SPACE 3 - DATES

2.3.1  CREATION.  In Space 3(a), put the year the finished program
was created.  A program is created when it is fixed in some
permanent tangible form.  This is not to say you cannot change it
later since each significant version constitutes a copyrightable
work.  In any event, make sure the creation date is consistent with
other dates appearing on the application and in the program.

2.3.2  PUBLICATION.  A program is published when it is sold,
transferred, assigned, licensed, rented, leased, or offered for
distribution to the public.  If your program has never been
published, just leave the date and nation information in Space 3(b)
blank.  If your program has been published, then you must give the
date and nation where it was first published.  The approximate date
is acceptable if you cannot recall exactly.


2.4  SPACE 4 - CLAIMANT

     The claimant is the person or company who is now claiming
ownership and title in the copyright, or at least part of it. 
Usually, the claimant and the author are the same.  However, the
claimant may be different when there has been an assignment or some
other form of transfer from the author originally named in Space 2. 
If that is case, a brief transfer statement must be made (see
Section 2.4.4).  In pseudocode:

     IF SPACE 4 = SPACE 2
        NO TRANSFER STATEMENT REQUIRED
     ELSE
        TRANSFER STATEMENT REQUIRED. 

2.4.1  If the claimant is the SAME as the author named in Space 2,
put his or her or its name and address in Space 4, Line 1. 
Obviously, you do not need a transfer statement if there has been
no transfer.

2.4.2  If the claimant is DIFFERENT from the author named in Space
2, you need to explain this discrepancy.  Thus, in Space 4, Line 1
give the claimant's full name and address, and on Line 2 give a
brief statement how title was transferred (see Section 2.4.4).

2.4.3  If there were joint authors and the claimant is less than
ALL of the authors, again you will need to explain this.  In Space
4, Line 1 give this claimant's full name and address, and on Line
2 give a brief transfer statement how this claimant got title to
the entire work was obtained (see Section 2.4.4). 

2.4.4  TRANSFER STATEMENT.  The transfer statement is a very brief
explanation how the claimant got ownership.  It is NOT the document
itself.  Rather, the transfer statement need only be a word or two,
such as "BY ASSIGNMENT" or "BY WRITTEN AGREEMENT."   Do NOT attach
the transfer document itself.  However, transfer documents can be
filed separately with the Copyright Office by sending a letter of
request and a $10.00 filing fee per document. 


 2.5  SPACE 5 - PREVIOUS REGISTRATION

     Each version or release of a program is a different work.  If
you have registered your program before, check "YES" in the TOP box
in Space 5, plus check one or more of the next 3 boxes in Space 5
to explain why another registration is being sought.  Those reasons
include: 

  (1)  The program was unpublished when you first registered, and
you now seek a second registration to cover your first published
edition.  Check the SECOND box. 

  (2)  The program was previously registered by somebody else
(perhaps a co-author), and you now seek registration in your name. 
Check the THIRD box. 

  (3)  You revised the program since the first registration, and
now seek registration on the changed version.  Check the FOURTH box
AND complete Space 6.

     If you checked "YES" to the TOP box, you must give the
previous registration number and the year of registration on the
bottom line of Space 5.  If you made more than one registration of
this program, you need only give the latest registration number and
year. 


2.6  SPACE 6 - DERIVATIVE WORKS or COMPILATIONS

     You only need to complete Space 6 if your program is a
derivative work, a changed version of another work, or a
compilation of preexisting works (see Sections 1.3 and 2.5 above).
Derivative or changed works are based upon or derived from one or
more preexisting works.  A compilation collects or assembles
preexisting materials from various sources, or extracts and
reassembles material or data from another source.  You must
complete Spaces 6a and 6b for derivative or changed works, but for
compilations you need only complete Space 6b. 
 
2.6.1  PREEXISTING MATERIAL.  Space 6a is for derivative works or
changed versions only.  Here, briefly describe the preexisting
material or program you updated, adapted or transformed.  That is,
identify any preexisting works your program may be based on or
incorporate.  This may include public domain or government material
(see examples in Section 2.6.3) 

2.6.2  MATERIAL ADDED.  Space 6b is for derivative works and
compilations.  The Copyright Office wants a BRIEF statement of any
added material in which you now claim copyright.  If you have a
derivative or changed work, give a short description what is new
about this changed version.  Or if you have a compilation, start
your description with the word "COMPILATION," then summarize
briefly your efforts in creating this work.  

2.6.3  EXAMPLES.  Examples of how you might complete Spaces 6a and
6b for derivative works and/or compilations are set forth below:

  (1)  For a derivative work, such as WordPerfect 5.1 -
         6a - "WordPerfect 5.0"
         6b - "Additional features and text"

  (2)  For a compilation, such as the PC Mag Utilities Disk -     
     6a - (leave blank)
         6b - "Compilation of DOS utilities and text"

  (3)  For a derivative work AND compilation, such as a 
       program incorporating public domain material - 
         6a - "Standard file compression routines"
         6b - "Additional programming and text"


2.7  SPACE 7 - (DELETED) 

     In the past, Space 7 was used for manufacturing provisions,
but it is no longer required.  The new TX forms have deleted this
space.  If you happen to have an old TX form, just leave Space 7
blank. 


2.8  SPACE 8 - REPRODUCTION FOR BLIND OR HANDICAPPED

     The Library of Congress reproduces and distributes some works
for use by blind or physically handicapped individuals.  If you
wish to grant the Library of Congress a limited right to copy and
distribute your work solely for the blind or handicapped, check Box
8b and sign your name.  You can always terminate this license upon
90 days notice.


2.9  SPACE 9 - CORRESPONDENCE FROM OFFICE

     Skip the first half of Space 9, DEPOSIT ACCOUNT, unless of
course you have a charge account with the Copyright Office )if that
is the case, why do you need this booklet?) 

     However, the second half of Space 9 is very important in case
the Copyright Examiner needs to contact you.  Give your name (or
person most suited to answer questions), an address and daytime
telephone number  Often a simple phone call from the Examiner can
straighten out the problem. 


2.10  SPACE 10 - SIGNATURE AND CERTIFICATION

     Finally, you get to sign the application in Space 10.  In the
top part of Space 10, check one of the boxes indicating your status
as the:  (a) author;  (b) other copyright claimant;  (c) owner of
exclusive rights;  or (d) authorized agent of a, b or c. 
     On the middle line of Space 10, type or print your name and
the date you signed the application.  Make sure that if you listed
the work as published in Space 3, the date signed is later than the
date published. 
     Put your signature on the bottom line of Space 10, where the
finger is pointing.  By signing the application, you are certifying
that everything is true and accurate to the best of your knowledge. 
The TX form warns that any false representation of a material fact
in an application for copyright or in any written statement filed
in connection with it SHALL be fined up to $2,500.   


2.11  SPACE 11 - MAILING ADDRESS FOR CERTIFICATE 

     In Space 11, give the name and full mailing address where you
want the Certificate of Copyright Registration mailed.  Usually,
this is the same address you have used time after time herein.  But
if you want, you can have the Certificate mailed somewhere else. 


  ================================================================


CHAPTER 3:  FINAL STEPS

3.1  FILING FEE = $20.00

     The required filing fee for each application is $20.00 (twenty
dollars) effective January 3, 1991.  This fee is non-refundable. 
Make your check or money order payable to the "Register of
Copyrights" and be sure to send a cover letter (see section 3.3).

3.2  DEPOSIT REQUIREMENTS

     The Copyright Office requires that you deposit with the
Library of Congress a "best edition" of your work.  In most cases,
the best edition of a computer program is its source code.  The
source code may be deposited in any form visually perceptible
without the aid of a machine or device, on paper or microform,
preferably showing the copyright notice.  Filing on floppy disks
and magnetic media is being considered, but is not yet required. 

     You do not have to deposit the entire source listing.  Rather,
you can file with the Copyright Office representative deposits of
your program in the following ways:

  (1)  The first 25 and last 25 pages of source code.
 
  (2)  If you have multiple programs, the first 25 pages from the
first program and the last 25 pages from the last program.

  (3)  If you have a revised version, and no changes or additions
are contained in the first 25 and last 25 pages, you can send any
50 representative pages of the revised material.

     By far, most people use the first option, but if you hesitate
to disclose ANY of your source code, special deposit procedures are
available as explained in the following Section. 

3.2.1  SPECIAL RELIEF AND TRADE SECRETS.  Since Copyright Office
records are open to the public, trade secrets could be lost if you
deposit a significant portion of your source code. Recognizing this
possibility, the Copyright Office provides for special relief from
the above deposit options.   Write a letter to the Chief Examiner
requesting special relief, and the following deposit options are
available:

  (1)  The first 25 and last 25 pages of source code with up to 50%
blocked out.  The blocked-out portions must be proportionately less
than the material remaining.  Some people photocopy the source code
through a clear plastic sheet with masking tape blocking out half
the sheet.  

  (2)  The first and last 10 pages of source code with NO blocked
out portions.

  (3)  The first and last 25 pages of object code, plus any 10 or
more consecutive pages of source code with NO blocked-out portions.

3.2.2  OBJECT CODE AND RULE OF DOUBT.  As mentioned before, in rare
cases you may deposit object code.  Deposits of object code are
subject to the Copyright Office's "Rule of Doubt."  This means that
the Copyright Office has accepted the deposit material for filing
purposes without making any independent determination of its
copyrightability. 

3.2.3  COMPUTER SCREEN DISPLAYS.  Computer programs and screen
displays should be registered as a single work.   All copyrightable
expression owned by the same claimant and embodied in a computer
program, or first published as a unit with a computer program,
including computer screen displays, is considered a single work and
should be registered on a single application form.  

     There is no need to refer to screen displays on the TX
application.  However, once you mention screens or other audio-
visual whistles and bells, you must send copies of screens, 
printouts, photographs, drawings, or VHS and the Copyright Examiner
will be forced to make a judgment call on each screen.  Deposit of
screen displays is disfavored by the Copyright Office and will
drastically slow down the application process. 


3.3  MAILING 

     Pack up your application form, the deposit material, and the 
filing fee, and address the whole package to: 

                  Register of Copyrights
                  Library of Congress
                  Washington D.C.  20559

     Regular U.S. mail is fine, certified or registered delivery is
not necessary.  However, it is a good idea to send include a cover
letter listing the contents of your package.  It also helps to
include a self-addressed postcard for the Copyright Office mailroom
to date-stamp and return to you acknowledging receipt (see
Appendix).  On the postcard, list everything sent in the package. 


3.4  OFFICE ACTION 

     Processing by the Copyright Office usually takes about three
to six months.  If the Examiner has any questions, you will receive
a letter or phone call.  Communications are quite informal, but you
do need to reply to Office actions no later than six months. 
Hopefully, the only thing you will receive is a big brown U.S.
government envelope containing your Certificate of Copyright
Registration.


3.5  ABOUT THE AUTHOR
 
     Beach A. Craigmyle is an attorney in Louisville, Kentucky. 
He was a former programmer/analyst and information systems auditor.
He concentrates his law practice in the area of intellectual property,
computer law, business law and litigation.  His office address is: 
2500 Brown & Williamson Tower, Louisville, Kentucky 40202, phone
(502) 584-1135, FAX (502) 561-0442.  He may be reached through
the Internet at 72426.2567@COMPUSERVE.COM, GEnie (B.CRAIGMYLE), and 
on CompuServe (72426,2567). 

================================================================

                         APPENDIX

     The documents included in the appendixes below could not be
attached to the disk version of this booklet because they are
typeset.  Basically, they look like any other government document
with lots of lines, boxes, and fine print.   

================================================================  
                      APPENDIX A
                 Blank Forms TX and TX/CON
================================================================  
                      APPENDIX B
                 Example TX Form Completed
           Certificate of Copyright Registration
================================================================  
                      APPENDIX C
               Request for Special Handling 
================================================================  
                      APPENDIX D
             Correspondence with Copyright Office
             1.  Transmittal letter
             2.  Request for Special Relief 

================================================================

                          INDEX
  References are to Sections and to Appendixes.

Abridgements, 2.6
Additions, 1.2, 2.6.2
Anonymity, 2.2.4
Assignment, 2.4.4
Authorship, 2.2.5
BBS support, 3.5
Birthdate, 2.2.1
Blind or handicapped, 2.8
Business name, 2.2.1
Certificate, 1.3, 2.11, Appx B
Claimant, 2.4, 2.2
Coauthor, see Joint
Collection, 2.1
Compilations, 1.2, 2.6
Copying, 1.3, 1.4
Correspondence, 3.3
Courts, 1.3, 1.4
Creation, 1.5, 2.3.1
Damages, 1.4
Dates, 1.4, 2.3
Deposit material, 3.2
Derivative works, 1.2, 2.6
Documentation, 1.2, 3.2
Domicile, 2.2.3
Employment, 2.2.2, 2.4
Expedited handling, 1.4
Expressions, 1.1, 1.2
Fees 2.0, 1.4
Help, 3.5
Ideas 1.1, 1.2
Infringement 1.4
Injunction, 1.3
Joint authors, 2.2, 2.4.3, 2.5
Judgment, 1.4
Mailing address, 2.9, 2.11, 3.3
Merger doctrine, 1.2
Microcode, 1.2
Nationality, 2.2.3
Notice, 1.5
Object code, 1.2, 3.2.2
Patents, Intro, 1.5
Preexisting material, 2.6
Previous registration, 2.5
Pseudonym, 2.2.4
Public domain, 1.2, 2.6.3
Publication, 2.3.2, 2.5, 2.10
Rights, 1.3, 1.2
Rule of doubt, 3.2.2
Screen displays, 1.2, 3.2.3
Signature, 2.10
Similarity, 1.4
Source code, 1.2, 3.2, 3.2.1
Special handling, 1.4, Appx C
Special relief, 3.2.1, Appx D
Titles, 2.1, 2.5
Trade Secrets, 1.5, 3.2.1
Trademarks, Intro, 1.5, 2.1
Transfer statement, 2.4, 2.4.4
Translations, 1.2, 2.6
TX Form, 2.0, Appx A
User interface, 1.1, 1.3
User manual, 1.2, 3.2
Work for hire, 2.2, 2.2.2
Written agreement, 2.2.2, 2.4.4

=========================[ END ]================================