//
//  MSDocument.m
//  Okusa
//
//  Created by 木谷 洋 on 12/01/30.
//  Copyright (c) 2012年 二鏡庵. All rights reserved.
//


#import "MSDocument.h"
#import "MSPager.h"
#import "MSPageFormat.h"
#import "MSTextView.h"
#import "MSLayoutBlockManager.h"
#import "MSDocumentController.h"

extern NSString *udFileInfoMap;

// mapのfile名->辞書で、その中にさらにencoding情報とselectionポジションが保持されている。
// 外部アプリでエンコードを変えた場合は不定
// selectionが不正領域になったら行末とする
static NSString *udkEncodingKey = @"encoding";
static NSString *udkSelectionKey = @"selection";


@implementation MSDocument
@synthesize encoding;
- (id)init
{
    self = [super init];
    if (self) {
        // Add your subclass-specific initialization here.
        // If an error occurs here, return nil.
        content = [[MSLayoutBlockManager alloc] init];
        pager = [[MSPager alloc] init];
        pager.content = content;
        
        // ここは最終的にデフォルトからロードすべき
        MSPageFormat *format = [[MSPageFormat alloc] initWithSpacingMode: eLineSpacingMode_Half
                                                                 padding: NSMakeSize(8.0,16.0) 
                                                                fontName: @"HiraMinPro-W3"
                                                                fontSize: 28.0
                                                                boxCount: 20];
        pager.format = format;
        self.encoding = NSUTF8StringEncoding;
    }
    return self;
}

- (void)awakeFromNib
{
    pager.textView = textView;
    textView.delegate = self;
    
    id window = [textView window];
    [window useOptimizedDrawing: YES];
    
    NSSize size = [pager.format standardSizeForNewWindow];
    NSRect visibleFrame = [[NSScreen mainScreen] visibleFrame];
    size.width  = MIN(size.width, NSWidth(visibleFrame));
    size.height = MIN(size.height, NSHeight(visibleFrame));
    [window setContentSize: size];
    [window center];
    
    if(NSEqualRanges(initialState.selection, NSMakeRange(0,0)))
    {
        [textView moveToEndOfDocument: self];
    }
    else
    {
        NSUInteger length = pager.content.textStorage.length;
        if( NSMaxRange(initialState.selection) > length )
            [textView moveToEndOfDocument: self];
        else
            [textView setSelectedRange: initialState.selection];
    }
}

- (NSString *)windowNibName
{
    // Override returning the nib file name of the document
    // If you need to use a subclass of NSWindowController or if your document supports multiple NSWindowControllers, you should remove this method and override -makeWindowControllers instead.
    return @"MSDocument";
}

- (NSData *)dataOfType:(NSString *)typeName error:(NSError **)outError
{
    if(UTTypeConformsTo((CFStringRef)typeName, kUTTypePlainText))
    {
        id data = [pager.content dataWithEncoding: self.encoding];
        return data;
    }
    
    return nil;
}

- (BOOL)readFromData:(NSData *)data ofType:(NSString *)typeName error:(NSError **)outError
{
    if(UTTypeConformsTo((CFStringRef)typeName, kUTTypePlainText))
    {
        NSInteger aEncoding;

        // 条件が書きにくいため、先にデフォルトの挙動
        aEncoding = [[NSDocumentController sharedDocumentController] selectedEncoding];
        if(aEncoding == 0)
            aEncoding = NSUTF8StringEncoding;        
        initialState.selection = NSMakeRange(0,0);

        // 可能ならばUDで上書き
        id ud = [NSUserDefaults standardUserDefaults];
        id map = [ud objectForKey: udFileInfoMap];
        if(map)
        {
            id info = [map objectForKey: [self.fileURL path]];
            if(info)
            {
                aEncoding = [[info objectForKey: udkEncodingKey] integerValue];
                id rangeData = [info objectForKey: udkSelectionKey];
                id val = [NSUnarchiver unarchiveObjectWithData: rangeData];
                initialState.selection = [val rangeValue];
            }
        }

        self.encoding = aEncoding;
        
        id str = [[NSString alloc] initWithData: data
                                       encoding: aEncoding];
        if(str == nil)
        {
            // テキストファイルではないか、エンコーディングが間違っています
            return NO;
        }
        
        id aStr = [pager.format formatString: str];
        if(aStr == nil)
            return NO;
        
        [pager.content loadString: aStr];
        
        return YES;
    }
    
    if(UTTypeConformsTo((CFStringRef)typeName, kUTTypeRTF))
    {
        id aStr = [[NSAttributedString alloc] initWithRTF: data 
                                       documentAttributes: nil];
        if(aStr == nil)
            return NO;
        
        aStr = [self normalizeAttributedString: aStr];
        [pager.content loadString: aStr];
        self.fileURL = nil;
        return YES;
    }


    return NO;
}

- (NSDictionary*)fileInfo
{
    NSRange range = [textView selectedRange];
    id val = [NSValue valueWithRange: range];
    id rangeData = [NSArchiver archivedDataWithRootObject: val];
    id dic = [NSDictionary dictionaryWithObjectsAndKeys: 
              [NSNumber numberWithInteger: self.encoding], udkEncodingKey,
              rangeData, udkSelectionKey,
              nil];
    return dic;
}

+ (BOOL)autosavesInPlace
{
    return NO;
}

- (NSDictionary*)standardAttributes
{
    return [NSDictionary dictionaryWithObjectsAndKeys:
            pager.format.font, NSFontAttributeName,
            [NSColor blackColor], NSForegroundColorAttributeName,
            nil];
}

- (NSAttributedString*)normalizeAttributedString:(NSAttributedString*)aStr
{
    id newStr = [aStr mutableCopy];
    id str = [newStr mutableString];
    id attach = [NSString stringWithFormat: @"%C", NSAttachmentCharacter];
    [str replaceOccurrencesOfString: attach
                         withString: @"" 
                            options: NSLiteralSearch
                              range: NSMakeRange(0, [str length])];
    [newStr setAttributes: [self standardAttributes]
                    range: NSMakeRange(0,[newStr length])];
    return newStr;
}
@end
