/**
 * @file	tsk.h
 *
 */

#ifndef _TSK_H_
#define _TSK_H_

#include <itron.h>
#include "lst.h"

// TODO ẄڐÂ߂̎b[u
#define	WTIM	(0x4000)

/* pTCB\ */
typedef struct S_TCB
{
	T_LST			lst;				/**< list controller					*/

	ID				tskid;				/**< ^XNhcԍ						*/

	VP				exinf;				/**< g							*/
	ATR				tskatr;				/**< ^XN							*/
	FP				task;				/**< ^XNNAhX					*/
	PRI				itskpri;			/**< ^XNNDx					*/
	INT				stksz;				/**< X^bNTCY						*/

	PRI				tskpri;				/**< ݂̗Dx						*/
	UINT			tskstat;			/**< ^XN							*/
	UINT			tskwait;			/**< ҂v							*/
	ID				wid;				/**< ҂ŝhc						*/
	INT				wupcnt;				/**< NvL[CO				*/
	INT				suscnt;				/**< SUSPENDvlXg					*/

	ER				*p_wercd;			/**< ҂ʂ̃AhX					*/

	union U_WAIT
	{
		struct S_WFLG
		{
			UINT	wfmode;				/**< tO҂[h						*/
			UINT	waiptn;				/**< ҂tOp^[					*/
			UINT	flgptn;				/**< ҂̃tOp^[			*/
		} wflg;

		struct S_WMBX
		{
			T_MSG	**ppk_msg;			/**< bZ[WpPbg̐擪AhX	*/
		} wmbx;

		struct S_WMBF
		{
			VP		msg;				/**< MbZ[WAhX		*/
			INT		msgsz;				/**< MbZ[W̃TCY				*/
		} wmbf;

		struct S_WMPL {
			INT		blksz;				/**< ubNTCY					*/
			VP		blk;				/**< ubÑAhX				*/
		} wmpl;

		struct S_WMPF
		{
			VP		blf;				/**< ubÑAhX				*/
		} wmpf;

	} wait;




	struct S_TCB	*next;				/**< TCBւ̃|C^				*/
	struct S_TCB	*prev;				/**< OTCBւ̃|C^				*/

//	PRI				pri;				/**< ^XNDx						*/
//	VH				sts;				/**< ^XNԃtO					*/

	VB				dmy[2];				/**< _~[							*/
	TMO				tmout;				/**< ^CAEg					*/
	VB				*arg;				/**< ̃AhX					*/

//	FP				sta_func;			/**< X^[gAhX					*/
//	VB				*end_func;			/**< I֐̃AhX			*/
//	VB				*stack;				/**< X^bNl					*/
//	VB				*sp;				/**< X^bN|C^					*/

//	PRI				endpri;				/**< Is̗Dx			*/
	UH				susmask;			/**< SUSPEND }XN				*/
//	UH				ipri;				/**< ^XNDx					*/
//	UB				size;				/**< X^bNTCY(KB)				*/
//	UB				r_size;				/**< cX^bNTCY(%)			*/
//	UW				*scp;				/**< X^bN`FbN|Cg			*/


	/* ÃV~[^Ǝ̎ */
	B				name[16];			/**< ^XN							*/

} T_TCB;

typedef struct S_TCBTMO
{
		ID			tskid;				/* ^XNIDԍ						*/
		PRI			_pri;				/* _~[							*/
		VH			sts;				/* ^XNԃtO					*/
		ID			_wid;				/* _~[							*/
		T_TCB		*next;				/* TCBւ̃|C^				*/
		T_TCB		*prev;				/* OTCBւ̃|C^				*/

		VH			_wfmode;			/* _~[							*/
		VH			_waiptn;			/* _~[							*/
		UH			_wupcnt;			/* _~[							*/
		UH			_suscnt;			/* _~[							*/
		TMO			tmout;				/* ^CAEg					*/
		T_TCB		*tcb;				/* TCB ̖{						*/
} T_TCBTMO;

/*--------------------------------------------------------------------------*/
/*                    fBL[ǗubN ( RDQ )                      */
/*--------------------------------------------------------------------------*/
typedef struct S_RDQ
{
	T_LST lst;

	T_TCB *head;
} T_RDQ;

/* ^XNVXȅ */
int tsk_initialize(void);

/* ^XNVXȅI */
void tsk_terminate(void);

ER kernel_cre_tsk(T_TCB *p_tcb);

/* ^XNID擾 */
ER kernel_tsk_get_self_tskid(ID *p_tskid);

/* TCB𓾂 */
ER tsk_get_tcb(ID tskid, T_TCB** pp_tcb);

/* fBXpb`܂ő҂ */
/* p_kernel_tcbNULLw肷ƁAubNȂ */
void tsk_wait_dispatch(void);

/* ^XNXPW[ɃfBXpb`܂ő҂ */
void tsk_dispatch(void);

/* ҂^XNXgɌqꂽ^XN̑҂Ԃ */
void tsk_wait_delete(T_LST *p_wtsklst);

void tsk_wait_release(T_TCB *p_tcb, ER ercd);

#define	TSK_GET_WTSKID(p_wtsklst) ((BOOL_ID)(lst_empty(p_wtsklst) ? FALSE : ((T_TCB *)(p_wtsklst))->tskid))

ER end_func_set(ID tskid);



#endif /* _TSK_H_ */
