/**
 * @file	sys.c
 * @brief
 */
#include "sys.h"
#include "it3_common.h"
#include "it3_config.h"

#define	ISVALID_FNCD(fncd)		((0 < (fncd)) && ((fncd) < TNUM_SVC))
#define	ISVALID_SVCATR(svcatr)	(TRUE)	/* l̓`FbNȂ */

#define	ISVALID_EXCKIND(exckind)	((0 < (exckind)) && ((exckind) < TNUM_EXC))
#define	ISVALID_EXCATR(excatr)		(TRUE)	/* l̓`FbNȂ */

typedef struct S_SVCCB
{
	FN			s_fncd;

	ATR			svcatr;		/* gSVCnh */
	FP			svchdr;		/* gSVCnhAhX */
} T_SVCCB;

typedef struct S_EXCCB
{
	UINT		exckind;

	ATR			excatr;		/* Onh */
	FP			exchdr;		/* OnhAhX */
} T_EXCCB;


static const T_SVCCB svccb_initializer = {0};

static const T_EXCCB exccb_initializer = {0};

static T_SVCCB svccbs[TNUM_SVC];

static T_EXCCB exccbs[TNUM_EXC];

ER sys_initialize(void)
{
	INT cnt;

	for(cnt = 0;cnt < TNUM_SVC;cnt++)
	{
		svccbs[cnt] = svccb_initializer;
	}

	return E_OK;
}

void sys_terminate(void)
{
}

ER get_ver(T_VER *pk_ver)
{
	ER result;

	if(ISVALID_PTR(pk_ver))
	{
		pk_ver->maker = TKERNEL_MAKER;
		pk_ver->id = TKERNEL_PRID;
		pk_ver->spver = TKERNEL_SPVER;
		pk_ver->prver = TKERNEL_PRVER;
		pk_ver->prno[0] = TKERNEL_PRNO0;
		pk_ver->prno[1] = TKERNEL_PRNO1;
		pk_ver->prno[2] = TKERNEL_PRNO2;
		pk_ver->prno[3] = TKERNEL_PRNO3;
		pk_ver->cpu = TKERNEL_CPU;
		pk_ver->var = TKERNEL_VAR;

		result = E_OK;
	}
	else
	{
		result = E_PAR;
	}

	return result;
}

ER ref_sys(T_RSYS *pk_rsys)
{
	ER result;

	if(ISVALID_PTR(pk_rsys))
	{
		pk_rsys->sysstat = 0;	// TODO ǂȁ[

		result = E_OK;
	}
	else
	{
		result = E_PAR;
	}

	return result;
}

ER ref_cfg(T_RCFG *pk_rcfg)
{
	ER result;

	if(ISVALID_PTR(pk_rcfg))
	{

		result = E_OK;
	}
	else
	{
		result = E_PAR;
	}

	return result;
}

ER def_svc(FN s_fncd, T_DSVC *pk_dsvc)
{
	ER result;

	if(ISVALID_FNCD(s_fncd))
	{
		T_SVCCB *p_svccb;

		p_svccb = &(svccbs[s_fncd]);

		if(ISVALID_PTR(pk_dsvc))
		{
			if(ISVALID_SVCATR(pk_dsvc->svcatr))
			{
				*p_svccb = svccb_initializer;

				p_svccb->s_fncd = s_fncd;
				p_svccb->svcatr = pk_dsvc->svcatr;
				p_svccb->svchdr = pk_dsvc->svchdr;

				result = E_OK;
			}
			else
			{
				result = E_RSATR;
			}
		}
		else
		{
			*p_svccb = svccb_initializer;
			result = E_OK;
		}
	}
	else
	{
		result = E_PAR;
	}

	return result;
}

ER def_exc(UINT exckind, T_DEXC *pk_dexc)
{
	ER result;

	if(ISVALID_EXCKIND(exckind))
	{
		T_EXCCB *p_exccb;

		p_exccb = &(exccbs[exckind]);

		if(ISVALID_PTR(pk_dexc))
		{
			if(ISVALID_SVCATR(pk_dexc->excatr))
			{
				*p_exccb = exccb_initializer;

				p_exccb->exckind = exckind;
				p_exccb->excatr = pk_dexc->excatr;
				p_exccb->exchdr = pk_dexc->exchdr;

				result = E_OK;
			}
			else
			{
				result = E_RSATR;
			}
		}
		else
		{
			*p_exccb = exccb_initializer;
			result = E_OK;
		}
	}
	else
	{
		result = E_PAR;
	}

	return result;
}
