#include "mpl.h"
#include "it3_common.h"
#include "it3_config.h"

#define	ISVALID_MPLID(mplid)		((0 < (mplid)) && ((mplid) < TNUM_MPL))
#define	ISVALID_MPLATR(mplatr)		(TRUE)	/* ̓`FbNȂ */

typedef struct S_MPLCB
{
	ID						mplid;

	VP						exinf;			/* g						*/
	ATR						mplatr;			/* v[				*/
	INT						mplsz;			/* v[Ŝ̃TCY		*/

} T_MPLCB;

static const T_MPLCB mplcb_initializer = {0};

static T_MPLCB mplcbs[TNUM_MPL];

ER mpl_initialize(void)
{
	INT cnt;

	for(cnt = 0;cnt < TNUM_MPL;cnt++)
	{
		mplcbs[cnt] = mplcb_initializer;
	}

	return E_OK;
}

void mpl_terminate(void)
{

}

ER cre_mpl(ID mplid, T_CMPL *pk_cmpl)
{
	ER result;

	if(ISVALID_MPLID(mplid))
	{
		if(ISVALID_PTR(pk_cmpl) && ISVALID_MPLATR(pk_cmpl->mplatr))
		{
			T_MPLCB *p_mplcb;

			p_mplcb = &(mplcbs[mplid]);

			if(0 == p_mplcb->mplid)
			{
				*p_mplcb = mplcb_initializer;

				p_mplcb->mplid = mplid;

				p_mplcb->exinf = pk_cmpl->exinf;
				p_mplcb->mplatr = pk_cmpl->mplatr;
				p_mplcb->mplsz = pk_cmpl->mplsz;

				result = E_OK;
			}
			else
			{
				result = E_OBJ;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

ER del_mpl(ID mplid)
{
	ER result;

	if(ISVALID_MPLID(mplid))
	{
		T_MPLCB *p_mplcb;

		p_mplcb = &(mplcbs[mplid]);

		if(0 != p_mplcb->mplid)
		{
			*p_mplcb = mplcb_initializer;

			result = E_OK;
		}
		else
		{
			result = E_NOEXS;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

ER get_blk(VP *p_blk, ID mplid, INT blksz)
{
	return tget_blk(p_blk, mplid, blksz, TMO_FEVR);
}

ER pget_blk(VP *p_blk, ID mplid, INT blksz)
{
	return tget_blk(p_blk, mplid, blksz, TMO_POL);
}

ER ipget_blk(VP *p_blk, ID mplid, INT blksz)
{
	return E_NOSPT;
}

ER tget_blk(VP *p_blk, ID mplid, INT blksz, TMO tmout)
{
	ER result;

	if(ISVALID_MPLID(mplid))
	{
		if(ISVALID_PTR(p_blk) && (0 < blksz) && ISVALID_TMOUT(tmout))
		{
			T_MPLCB *p_mplcb;

			p_mplcb = &(mplcbs[mplid]);

			if(0 != p_mplcb->mplid)
			{
				// TODO ǂȁ[
				result = E_NOSPT;
			}
			else
			{
				result = E_NOEXS;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

ER rel_blk(ID mplid, VP blk)
{
	ER result;

	if(ISVALID_MPLID(mplid))
	{
		if(ISVALID_PTR(blk))
		{
			T_MPLCB *p_mplcb;

			p_mplcb = &(mplcbs[mplid]);

			if(0 != p_mplcb->mplid)
			{
				// TODO ǂȁ[
				result = E_NOSPT;
			}
			else
			{
				result = E_NOEXS;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}

ER ref_mpl(T_RMPL *pk_rmpl, ID mplid)
{
	ER result;

	if(ISVALID_MPLID(mplid))
	{
		if(ISVALID_PTR(pk_rmpl))
		{
			T_MPLCB *p_mplcb;

			p_mplcb = &(mplcbs[mplid]);

			if(0 != p_mplcb->mplid)
			{
				pk_rmpl->exinf = p_mplcb->exinf;
				pk_rmpl->wtsk = FALSE;		// TODO ǂȁ[
				pk_rmpl->frsz = 0;			// TODO ǂȁ[
				pk_rmpl->maxsz = 0;			// TODO ǂȁ[

				result = E_OK;
			}
			else
			{
				result = E_NOEXS;
			}
		}
		else
		{
			result = E_PAR;
		}
	}
	else
	{
		result = E_ID;
	}

	return result;
}
