#ifndef _IT3_CONFIG_H_
#define _IT3_CONFIG_H_

/* task */

/* Number of tasks */
#define	TNUM_TSK		(256)

/* semaphore */
/* Number of semaphore */
#define	TNUM_SEM		(256)

/* event flag */
/* Number of event flags */
#define	TNUM_FLG		(256)


/* data queue */
/* Number of data queue */
#define	TNUM_DTQ		(256)


/* mail box */
/* Number of mail box */
#define	TNUM_MBX		(256)


/* mutex */
/* Number of mutex */
#define	TNUM_MTX		(256)


/* message buffer */
/* Number of message buffer */
#define	TNUM_MBF		(256)


/* rendezvous port */
/* Number of rendezvous port */
#define	TNUM_POR		(256)


/* fixed-sized memory pool */
/* Number of fixed-sized memory pool */
#define	TNUM_MPF		(256)


/* memory pool */
/* Number of memory pool */
#define	TNUM_MPL		(256)


/* cyclic handler */
/* Number of cyclic handler */
#define	TNUM_CYC		(256)


/* alarm handler */
/* Number of alarm handler */
#define	TNUM_ALM		(256)


/* overrun handler */
/* Number of overrun handler */
#define	TNUM_OVR		(256)


/* interrupt service routine */
/* Number of interrupt handler */
#define	TNUM_INH		(256)
/* Number of interrupt service routine */
#define	TNUM_ISR		(256)
/* Number of interrupt number */
#define	TNUM_INT		(256)


/* super viser call */
/* Number of super viser call */
#define	TNUM_SVC		(256)


/* CPU exception handler */
/* Number of cpu exception handler */
#define	TNUM_EXC		(256)

/* Minimum value of task priority */
#define	TMIN_TPRI		(1)
/* Maximum value of task priority */
#define	TMAX_TPRI		(16)

/* Minimum value of message priority */
#define	TMIN_MPRI		(1)
/* Maximum value of message priority */
#define	TMAX_MPRI		(16)

/* Maker code of kernel */
#define	TKERNEL_MAKER		(0x0000)
/* Production ID of kernel */
#define	TKERNEL_PRID		(0x0000)
/*
 * ITRON spec version.
 *
 * 0xABBB
 *
 * A - TRON spec kind.
 * 0x0 TRONʂ̎dl(TADȂ)
 * 0x1 ITRONdl(ITRON1,ITRON2)
 * 0x2 BTRONdl
 * 0x3 CTRONdl
 * 0x5 ITRONdl(ITRON2.0,ITRON3.0,ITRON4.0)
 * 0x6 BTRONdl
 *
 * BBB - spec version.(BCD)
 *
 * ex) uITRON 03.02.02  => 0x5322
 */
#define	TKERNEL_SPVER		(0x5322)
/* Produnction version of kernel */
#define	TKERNEL_PRVER		(0x0000)
/* Production number of kernel */
#define	TKERNEL_PRNO0		(0x0000)
#define	TKERNEL_PRNO1		(0x0000)
#define	TKERNEL_PRNO2		(0x0000)
#define	TKERNEL_PRNO3		(0x0000)
/* CPU information */
#define	TKERNEL_CPU			(0x0000)
/* Variation of kernel */
#define	TKERNEL_VAR			(0x0000)

/* Maximum value of task wake-up-request count */
#define	TMAX_WUPCNT		(16)
/* Maximum value of task force-wait-request nest count */
#define	TMAX_SUSCNT		(16)

/* Number of bits of task exception factor */
#define	TBIT_TEXPTN			(16)
/* Number of bits of event flag */
#define	TBIT_FLGPTN			(16)
/* Number of bits of rendezvous condition */
#define	TBIT_RDVPTN			(16)

/* numerator of period of time tick */
#define	TIC_NUME			(1)
/* denominator of period of time tick */
#define	TIC_DENO			(1)

/* Size of data-queue-area required to store pieces of dtqcnt (bytes) */
#define	TSZ_DTQ(dtqcnt)		((SIZE)((UINT)(dtqcnt) * 1))
/* M郁bZ[W̗Dx̍ől maxmpri ̃[{bNX
KvȗDxʃbZ[WL[wb_̈̃TCY(oCg)
SIZE mprihdsz = TSZ_MPRIHD ( PRI maxmpri ) */
#define	TSZ_MPRIHD(maxmpri)	((SIZE)((PRI)(maxmpri) * 4 ))
/* TCY msgsz oCg̃bZ[W msgcnt obt@Ô
KvȃbZ[Wobt@̈̃TCY(ڈ̃oCg)
SIZE mbfsz = TSZ_MBF ( UINT msgcnt, UINT msgsz ) */
#define	TSZ_MBF(msgcnt, msgsz)	((SIZE)((UINT)(msgcnt) * (UINT)(msgsz)))
/* TCYblkszoCg̃ubNblkcntlł̂ɕKv
Œ蒷v[̈̃TCY(oCg)
SIZE mpfsz = TSZ_MPF ( UINT blkcnt, UINT blksz ) */
#define	TSZ_MPF(blkcnt, blksz)	((SIZE)((UINT)(blkcnt) * (UINT)(blksz)))
/* TCYblkszoCg̃ubNblkcntlł̂ɕKv
ϒv[̈̃TCY(ڈ̃oCg)
SIZE mplsz = TSZ_MPL ( UINT blkcnt, UINT blksz ) */
#define	TSZ_MPL(blkcnt, blksz)	((SIZE)((UINT)(blkcnt) * (UINT)(blksz)))

/* Maximum of maximum resource number of semaphore */
#define	TMAX_MAXSEM			(256)




/*--------------------------------------------------------------------------*/
/* uITRONV~[VJ[l̃Oo									*/
/*		0	:	J[lOo͂Ȃ									*/
/*		1	:	J[lOo͂										*/
/*--------------------------------------------------------------------------*/
#define		UITRON_KERNEL_LOG				1


#endif /* _IT3_CONFIG_H_ */
