/**
 * @file	alm.c
 * @brief	ԊǗ@\iA[j
 *
 * @author  nikarana
 * @date    2012/11/23
 *
 */

#include "alm.h"
#include "it3_common.h"
#include "it3_config.h"
#include <depend.h>

#define	ISVALID_ALMNO(almno)	((0 < (almno)) && ((almno) < TNUM_ALM))
#define	ISVALID_ALMATR(almatr)	(TRUE) /* ̓`FbNȂ */

/* A[nhǗ\ */
typedef struct S_ALMCB
{
	HNO			almno;							/**< A[nhԍ		*/

	VP			exinf;							/**< g				*/
	ATR			almatr;							/**< A[nh		*/
	FP			almhdr;							/**< A[nhAhX	*/
	UINT		tmmode;							/**< Nw胂[h		*/
	ALMTIME		almtim;							/**< nhN			*/

	ALMTIME		lfttim;							/**< 						*/

	UW			time;							/**< nhN			*/
	FP			hdr;							/**< A[nh			*/

} T_ALMCB;

static const T_ALMCB almcb_initializer = {0};

extern SYSTIME systime;

static T_ALMCB almcbs[TNUM_ALM];

/**
 * @brief	ԊǗ@\iA[j
 *
 * @return	G[R[h
 * @retval	E_OK	I
 */
ER alm_initialize(void)
{
	INT cnt;

	for(cnt = 0;cnt < TNUM_ALM;cnt++)
	{
		almcbs[cnt] = almcb_initializer;
	}

	return E_OK;
}

/**
 * @brief	ԊǗ@\iA[jI
 */
void alm_terminate(void)
{
}

/**
 * @brief	ԊǗ@\iA[j
 *
 * @param	steptime	oߎ(ms)
 */
void alm_timeevent(UW steptime)
{
	INT cnt;
	T_ALMCB *p_almcb;

	for(cnt = 0;cnt < TNUM_ALM;cnt++)
	{
		p_almcb = &(almcbs[cnt]);

		depend_EnterCriticalSection();

		if(ISVALID_PTR(p_almcb->almhdr))
		{
			if(steptime < p_almcb->time)
			{
				p_almcb->time -= steptime;
			}
			else
			{
				(p_almcb->almhdr)();

				*p_almcb = almcb_initializer;
			}
		}

		depend_LeaveCriticalSection();
	}
}

/**
 * @brief	A[nh`
 *
 * @param	almno	A[nhwԍ
 * @param	pk_dalm	A[nh`
 * @return	G[R[h
 * @retval	E_OK	I
 * @retval	E_NOMEM	s(ǗubNp̗̈悪mۂłȂ)
 * @retval	E_RSATR	\񑮐(almatrs邢͗płȂ)
 * @retval	E_PAR	p[^G[(almno, pk_dalm, almhdr, tmmode, almtims邢͗płȂ)
 */
ER def_alm(HNO almno, T_DALM *pk_dalm)
{
	ER result;

	if(ISVALID_ALMNO(almno))
	{
		T_ALMCB *p_almcb;

		p_almcb = &(almcbs[almno]);

		depend_EnterCriticalSection();

		if(ISVALID_PTR(pk_dalm))
		{
			if(ISVALID_ALMATR(pk_dalm->almatr))
			{
				if((TTM_ABS == pk_dalm->tmmode) || (TTM_REL == pk_dalm->tmmode))
				{
					if(! ((TTM_REL == pk_dalm->tmmode) && (pk_dalm->almtim.ltime < 0)))
					{
						*p_almcb = almcb_initializer;

						p_almcb->almno = almno;

						p_almcb->exinf = pk_dalm->exinf;
						p_almcb->almatr = pk_dalm->almatr;
						p_almcb->almhdr = pk_dalm->almhdr;
						p_almcb->tmmode = pk_dalm->tmmode;
						p_almcb->almtim = pk_dalm->almtim;

						p_almcb->hdr = pk_dalm->almhdr;
						p_almcb->time = pk_dalm->almtim.ltime;
						if(TTM_ABS == pk_dalm->tmmode)
						{
							p_almcb->time += systime.ltime;
						}

						result = E_OK;;
					}
					else
					{
						result = E_PAR;
					}
				}
				else
				{
					result = E_PAR;
				}
			}
			else
			{
				result = E_RSATR;
			}
		}
		else
		{
			*p_almcb = almcb_initializer;

			result = E_OK;;
		}

		depend_LeaveCriticalSection();
	}
	else
	{
		result = E_PAR;
	}

	return result;
}

/**
 * @brief	A[nhԎQ
 *
 * @param	pk_ralm	A[nh̏ԂԂpPbg̐擪AhX
 * @param	almno	A[nhwԍ
 * @return	G[R[h
 * @retval	E_OK	I
 * @retval	E_NOEXS	IuWFNg݂ĂȂ(almnõA[nh`ĂȂ)
 * @retval	E_PAR	p[^G[(almnopłȂ, ^[p[^p̃pPbgAhXgpłȂl)
 */
ER ref_alm(T_RALM *pk_ralm, HNO almno)
{
	ER result;

	if(ISVALID_ALMNO(almno) && ISVALID_PTR(pk_ralm))
	{
		T_ALMCB *p_almcb;

		p_almcb = &(almcbs[almno]);

		depend_EnterCriticalSection();

		if(0 != p_almcb->almno)
		{
			pk_ralm->exinf = p_almcb->exinf;
			pk_ralm->lfttim = p_almcb->lfttim;	// TODO ǂȁ[

			result = E_OK;
		}
		else
		{
			result = E_NOEXS;
		}

		depend_LeaveCriticalSection();
	}
	else
	{
		result = E_PAR;
	}

	return result;
}
