package org.cocos2d.tests;

import org.cocos2d.CCDirector;
import org.cocos2d.R;
import org.cocos2d.events.CCTouchDispatcher;
import org.cocos2d.layers_scenes_transitions_nodes.CCLayer;
import org.cocos2d.layers_scenes_transitions_nodes.CCScene;
import org.cocos2d.lib.Cocos2dActivity;
import org.cocos2d.sound.SoundEngine;

import android.os.Bundle;
import android.view.MotionEvent;

//
// Click and Move demo
// a cocos2d example
// http://www.cocos2d-iphone.org
//
public class SoundEngineTest extends Cocos2dActivity {
	// private static final String TAG = ClickAndMoveTest.class.getSimpleName();

	// private static final boolean DEBUG = true;
	public static SoundEngineTest app;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		app = this;

		// set landscape mode
		CCDirector.sharedDirector().setLandscape(false);

		// show Stats
		CCDirector.sharedDirector().setDisplayStats(true);

		// frames per second
		CCDirector.sharedDirector().setAnimationInterval(1.0f / 60);

		CCScene scene = CCScene.create();
		scene.addChild(new MainLayer(), 2);

		// Make the Scene active
		CCDirector.sharedDirector().runWithScene(scene);
	}

	static class MainLayer extends CCLayer {
		public MainLayer() {
			this.setTouchEnabled(true);
		}

		@Override
		public boolean ccTouchesBegan(MotionEvent event) {
			SoundEngine.sharedEngine().playEffect(app, R.raw.effect);
			return CCTouchDispatcher.kEventHandled;
		}

		@Override
		public void onEnter() {
			super.onEnter();
			SoundEngine.sharedEngine().playSound(app, R.raw.backsound, true);
		}

		@Override
		public void onExit() {
			SoundEngine.sharedEngine().pauseSound();
			super.onExit();
		}
	}
}
