package org.cocos2d.actions.interval;

import org.cocos2d.base_nodes.CCNode;
import org.cocos2d.cocoa.CCGeometry.CCPoint;

//
// MoveTo
//

/** Moves a CCNode object to the position x,y. x and y are absolute coordinates by modifying it's position attribute.
*/
public class CCMoveTo extends CCIntervalAction {
    private CCPoint endPosition = new CCPoint();
    private CCPoint startPosition = new CCPoint();
    protected CCPoint delta = new CCPoint();

    /** creates the action */
    public static CCMoveTo action(float t, CCPoint pos) {
        return new CCMoveTo(t, pos);
    }

    /** initializes the action */
    protected CCMoveTo(float t, CCPoint pos) {
        super(t);
        startPosition.setPoint(CCPoint.Zero);
        endPosition.setPoint(pos);
        delta.setPoint(CCPoint.Zero);
    }
    
    /**
     * Lets extend basic functionality for reuse action.
     */
    public void setEndPosition(CCPoint pos) {
    	endPosition.setPoint(pos);
    }

    @Override
    public CCIntervalAction copy() {
        return new CCMoveTo(duration, endPosition);
    }

    @Override
    public void start(CCNode aTarget) {
        super.start(aTarget);

        startPosition.setPoint(target.getPosition());
        delta.setPoint(endPosition.x - startPosition.x, endPosition.y - startPosition.y);
    }

    @Override
    public void update(float t) {
        target.setPosition(startPosition.x + delta.x * t,
        					startPosition.y + delta.y * t);
    }
}
